% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/weco_rules.R
\name{weco.info}
\alias{weco.info}
\title{Describe WECO rules}
\usage{
weco.info(rule, ..., prt = TRUE)
}
\arguments{
\item{rule}{WECO rule number from 1 to 8}

\item{...}{Specifications for individual rule
\describe{
 \item{k}{Number of "abnormal" data points}
 \item{l}{Number of standard deviations}
 \item{n}{Number of data points prior to the current point
(including the current point) to be evaluated}}}

\item{prt}{Whether to print the detailed information}
}
\value{
A list that contains a text description of the rule and a vector of
    parameters with their default values
}
\description{
Get the description of a WECO rule
}
\examples{

info.1 <- weco.info(rule=1);
print(info.1$description);
info.1 <- weco.info(rule=1, l=2);
print(info.1$description);

}

