% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/wnba_stats_boxscore.R
\name{wnba_boxscorescoringv2}
\alias{wnba_boxscorescoringv2}
\title{\strong{Get WNBA Stats API Boxscore Scoring V2}}
\usage{
wnba_boxscorescoringv2(
  game_id,
  start_period = 0,
  end_period = 14,
  start_range = 0,
  end_range = 0,
  range_type = 0,
  ...
)
}
\arguments{
\item{game_id}{Game ID}

\item{start_period}{start_period}

\item{end_period}{end_period}

\item{start_range}{start_range}

\item{end_range}{end_range}

\item{range_type}{range_type}

\item{...}{Additional arguments passed to an underlying function like httr.}
}
\value{
Returns a named list of data frames: sqlPlayersScoring, sqlTeamsScoring

\strong{sqlPlayersScoring}\tabular{ll}{
   col_name \tab types \cr
   GAME_ID \tab character \cr
   TEAM_ID \tab character \cr
   TEAM_ABBREVIATION \tab character \cr
   TEAM_CITY \tab character \cr
   PLAYER_ID \tab character \cr
   PLAYER_NAME \tab character \cr
   NICKNAME \tab character \cr
   START_POSITION \tab character \cr
   COMMENT \tab character \cr
   MIN \tab character \cr
   PCT_FGA_2PT \tab character \cr
   PCT_FGA_3PT \tab character \cr
   PCT_PTS_2PT \tab character \cr
   PCT_PTS_2PT_MR \tab character \cr
   PCT_PTS_3PT \tab character \cr
   PCT_PTS_FB \tab character \cr
   PCT_PTS_FT \tab character \cr
   PCT_PTS_OFF_TOV \tab character \cr
   PCT_PTS_PAINT \tab character \cr
   PCT_AST_2PM \tab character \cr
   PCT_UAST_2PM \tab character \cr
   PCT_AST_3PM \tab character \cr
   PCT_UAST_3PM \tab character \cr
   PCT_AST_FGM \tab character \cr
   PCT_UAST_FGM \tab character \cr
}


\strong{sqlTeamsScoring}\tabular{ll}{
   col_name \tab types \cr
   GAME_ID \tab character \cr
   TEAM_ID \tab character \cr
   TEAM_NAME \tab character \cr
   TEAM_ABBREVIATION \tab character \cr
   TEAM_CITY \tab character \cr
   MIN \tab character \cr
   PCT_FGA_2PT \tab character \cr
   PCT_FGA_3PT \tab character \cr
   PCT_PTS_2PT \tab character \cr
   PCT_PTS_2PT_MR \tab character \cr
   PCT_PTS_3PT \tab character \cr
   PCT_PTS_FB \tab character \cr
   PCT_PTS_FT \tab character \cr
   PCT_PTS_OFF_TOV \tab character \cr
   PCT_PTS_PAINT \tab character \cr
   PCT_AST_2PM \tab character \cr
   PCT_UAST_2PM \tab character \cr
   PCT_AST_3PM \tab character \cr
   PCT_UAST_3PM \tab character \cr
   PCT_AST_FGM \tab character \cr
   PCT_UAST_FGM \tab character \cr
}
}
\description{
\strong{Get WNBA Stats API Boxscore Scoring V2}

\strong{Get WNBA Stats API Boxscore Scoring V2}
}
\details{
\if{html}{\out{<div class="sourceCode r">}}\preformatted{  wnba_boxscorescoringv2(game_id = "1022200034")
}\if{html}{\out{</div>}}
}
\seealso{
Other WNBA Boxscore Functions: 
\code{\link{wnba_boxscoreadvancedv2}()},
\code{\link{wnba_boxscorefourfactorsv2}()},
\code{\link{wnba_boxscoremiscv2}()},
\code{\link{wnba_boxscoreplayertrackv2}()},
\code{\link{wnba_boxscoresummaryv2}()},
\code{\link{wnba_boxscoretraditionalv2}()},
\code{\link{wnba_boxscoreusagev2}()},
\code{\link{wnba_gamerotation}()},
\code{\link{wnba_hustlestatsboxscore}()}
}
\author{
Saiem Gilani
}
\concept{WNBA Boxscore Functions}
