% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/wnba_stats_team.R
\name{wnba_teamgamelog}
\alias{wnba_teamgamelog}
\title{\strong{Get WNBA Stats API Team Game Log}}
\usage{
wnba_teamgamelog(
  date_from = "",
  date_to = "",
  league_id = "10",
  season = most_recent_wnba_season(),
  season_type = "Regular Season",
  team_id = "1611661328",
  ...
)
}
\arguments{
\item{date_from}{date_from}

\item{date_to}{date_to}

\item{league_id}{League - default: '00'. Other options include '10': WNBA, '20': G-League}

\item{season}{Season - format 2020-21}

\item{season_type}{Season Type - Regular Season, Playoffs, All-Star}

\item{team_id}{Team ID}

\item{...}{Additional arguments passed to an underlying function like httr.}
}
\value{
Return a named list of data frames: TeamGameLog

\strong{TeamGameLog}\tabular{ll}{
   col_name \tab types \cr
   Team_ID \tab character \cr
   Game_ID \tab character \cr
   GAME_DATE \tab character \cr
   MATCHUP \tab character \cr
   WL \tab character \cr
   W \tab character \cr
   L \tab character \cr
   W_PCT \tab character \cr
   MIN \tab character \cr
   FGM \tab character \cr
   FGA \tab character \cr
   FG_PCT \tab character \cr
   FG3M \tab character \cr
   FG3A \tab character \cr
   FG3_PCT \tab character \cr
   FTM \tab character \cr
   FTA \tab character \cr
   FT_PCT \tab character \cr
   OREB \tab character \cr
   DREB \tab character \cr
   REB \tab character \cr
   AST \tab character \cr
   STL \tab character \cr
   BLK \tab character \cr
   TOV \tab character \cr
   PF \tab character \cr
   PTS \tab character \cr
}
}
\description{
\strong{Get WNBA Stats API Team Game Log}

\strong{Get WNBA Stats API Team Game Log}
}
\details{
\if{html}{\out{<div class="sourceCode r">}}\preformatted{ wnba_teamgamelog(team_id = '1611661328')
}\if{html}{\out{</div>}}
}
\seealso{
Other WNBA Team Functions: 
\code{\link{wnba_leaguedashteamstats}()},
\code{\link{wnba_teamdashboardbyclutch}()},
\code{\link{wnba_teamdashboardbygamesplits}()},
\code{\link{wnba_teamdashboardbygeneralsplits}()},
\code{\link{wnba_teamdashboardbylastngames}()},
\code{\link{wnba_teamdashboardbyopponent}()},
\code{\link{wnba_teamdashboardbyshootingsplits}()},
\code{\link{wnba_teamdashboardbyteamperformance}()},
\code{\link{wnba_teamdashboardbyyearoveryear}()},
\code{\link{wnba_teamdashlineups}()},
\code{\link{wnba_teamdetails}()},
\code{\link{wnba_teamestimatedmetrics}()},
\code{\link{wnba_teamgamelogs}()},
\code{\link{wnba_teamgamestreakfinder}()},
\code{\link{wnba_teamhistoricalleaders}()},
\code{\link{wnba_teaminfocommon}()},
\code{\link{wnba_teamplayerdashboard}()},
\code{\link{wnba_teamplayeronoffdetails}()},
\code{\link{wnba_teamplayeronoffsummary}()},
\code{\link{wnba_teams}()},
\code{\link{wnba_teamvsplayer}()},
\code{\link{wnba_teamyearbyyearstats}()}
}
\author{
Saiem Gilani
}
\concept{WNBA Team Functions}
