test_that("WNBA Scoreboard V3", {
  skip_on_cran()
  skip_on_ci()
  
  x <- wnba_scoreboardv3(league_id = "10", game_date = "2023-05-26")
  
  cols <- c(
    "game_id",
    "game_code",
    "game_status",
    "game_status_text",
    "game_date",
    "game_time_utc",
    "game_et",
    "home_team_id",
    "home_team_name",
    "home_team_city",
    "home_team_tricode",
    "home_team_slug",
    "away_team_id",
    "away_team_name",
    "away_team_city",
    "away_team_tricode",
    "away_team_slug",
    "period",
    "game_clock",
    "regulation_periods",
    "series_game_number",
    "series_text",
    "if_necessary",
    "series_conference",
    "po_round_desc",
    "game_subtype",
    "game_home_leaders_person_id",
    "game_home_leaders_name",
    "game_home_leaders_player_slug",
    "game_home_leaders_jersey_num",
    "game_home_leaders_position",
    "game_home_leaders_team_tricode",
    "game_home_leaders_points",
    "game_home_leaders_rebounds",
    "game_home_leaders_assists",
    "game_away_leaders_person_id",
    "game_away_leaders_name",
    "game_away_leaders_player_slug",
    "game_away_leaders_jersey_num",
    "game_away_leaders_position",
    "game_away_leaders_team_tricode",
    "game_away_leaders_points",
    "game_away_leaders_rebounds",
    "game_away_leaders_assists",
    "team_home_leaders_person_id",
    "team_home_leaders_name",
    "team_home_leaders_player_slug",
    "team_home_leaders_jersey_num",
    "team_home_leaders_position",
    "team_home_leaders_team_tricode",
    "team_home_leaders_points",
    "team_home_leaders_rebounds",
    "team_home_leaders_assists",
    "team_away_leaders_person_id",
    "team_away_leaders_name",
    "team_away_leaders_player_slug",
    "team_away_leaders_jersey_num",
    "team_away_leaders_position",
    "team_away_leaders_team_tricode",
    "team_away_leaders_points",
    "team_away_leaders_rebounds",
    "team_away_leaders_assists",
    "team_season_leaders_flag",
    "home_wins",
    "home_losses",
    "home_score",
    "home_seed",
    "home_in_bonus",
    "home_timeouts_remaining",
    "home_periods",
    "away_wins",
    "away_losses",
    "away_score",
    "away_seed",
    "away_in_bonus",
    "away_timeouts_remaining",
    "away_periods",
    "league_id",
    "league",
    "broadcasters"
  )
  
  
  expect_equal(sort(colnames(x)), sort(cols))
  expect_s3_class(x, "data.frame")
  
  Sys.sleep(3)
  
})
