% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/probability_estimators.R
\name{nelson_method}
\alias{nelson_method}
\title{Estimation of Failure Probabilities using the Nelson-Aalen Estimator}
\usage{
nelson_method(x, status, id = NULL)
}
\arguments{
\item{x}{A numeric vector which consists of lifetime data. Lifetime
data could be every characteristic influencing the reliability of a product,
e.g. operating time (days/months in service), mileage (km, miles), load
cycles.}

\item{status}{A vector of binary data (0 or 1) indicating whether unit \emph{i}
is a right censored observation (= 0) or a failure (= 1).}

\item{id}{A vector for the identification of every unit. Default is \code{NULL}.}
}
\value{
A tibble containing the following columns:
\itemize{
\item \code{id} : Identification for every unit.
\item \code{x} : Lifetime characteristic.
\item \code{status} : Binary data (0 or 1) indicating whether a unit is a
right censored observation (= 0) or a failure (= 1).
\item \code{rank} : Filled with \code{NA}.
\item \code{prob} : Estimated failure probabilities, \code{NA} if \code{status = 0}.
\item \code{cdf_estimation_method} : Specified method for the estimation of
failure probabilities (always 'nelson').
}
}
\description{
\ifelse{html}{\figure{lifecycle-soft-deprecated.svg}{options: alt='Soft-deprecated lifecycle'}}{\strong{Soft-deprecated}}

\code{nelson_method()} is no longer under active development, switching
to \code{\link{estimate_cdf}} is recommended.
}
\details{
This non-parametric approach estimates the cumulative hazard rate in
terms of (multiple) right censored data. By equating the definition of the
hazard rate with the hazard rate according to Nelson-Aalen one can calculate
the failure probabilities.

\strong{Note} : The \emph{Nelson-Aalen} estimator does not assign ranks to
observations, so the beta-binomial confidence intervals \emph{cannot} be
calculated using this method.
}
\examples{
# Vectors:
obs   <- seq(10000, 100000, 10000)
state <- c(0, 1, 1, 0, 0, 0, 1, 0, 1, 0)
uic   <- c("3435", "1203", "958X", "XX71", "abcd", "tz46",
           "fl29", "AX23","Uy12", "kl1a")

# Example - Nelson-Aalen estimator applied to intact and failed units:
tbl_nel <- nelson_method(
  x = obs,
  status = state,
  id = uic
)

}
