% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/run.R
\name{run}
\alias{run}
\title{Execute single or multiple R, R Markdown, and Quarto scripts}
\usage{
run(
  input = "_whirl.yml",
  steps = NULL,
  summary_file = "summary.html",
  n_workers = zephyr::get_option("n_workers", "whirl"),
  check_renv = zephyr::get_option("check_renv", "whirl"),
  verbosity_level = zephyr::get_verbosity_level("whirl"),
  track_files = zephyr::get_option("track_files", "whirl"),
  out_formats = zephyr::get_option("out_formats", "whirl"),
  log_dir = zephyr::get_option("log_dir", "whirl")
)
}
\arguments{
\item{input}{A character vector of file path(s) to R, R Markdown, Quarto
scripts, or files in a folder using regular expression, or to to a whirl
config file. The input can also be structured in a list where each element
will be executed sequentially, while scripts within each element can be
executed in parallel.}

\item{steps}{An optional argument that can be used if only certain steps
within a config files (or list) is to be executed. Should be equivalent to
the names of the steps found in the config file. If kept as NULL (default)
then all steps listed in the config file will be executed.}

\item{summary_file}{A character string specifying the file path where the
summary log will be stored.}

\item{n_workers}{Number of simultaneous workers used in the run function.
A maximum of 128 workers is allowed.. Default: \code{1}.}

\item{check_renv}{Should the projects renv status be checked?. Default: \code{FALSE}.}

\item{verbosity_level}{Verbosity level for functions in whirl.
See \link[zephyr:verbosity_level]{zephyr::verbosity_level} for details.. Default: \code{NA_character_}.}

\item{track_files}{Should files read and written be tracked?
Currently only supported on Linux.. Default: \code{FALSE}.}

\item{out_formats}{Which log format(s) to produce. Possibilities are \code{html},
\code{json}, and markdown formats: \code{gfm}, \code{commonmark}, and \code{markua}.. Default: \code{"html"}.}

\item{log_dir}{The output directory of the log files. Default is the folder of
the executed script. log_dir can be a path as a character or it can be a
function that takes the script path as input and returns the log directory.
For more information see the examples of \code{run()} or \code{vignette('whirl')}.. Default: \code{function (x)  dirname(x)}.}
}
\value{
A tibble containing the execution results for all the scripts.
}
\description{
Executes and logs the execution of the scripts.
Logs for each script are stored in the same folder as the script.

The way the execution is logged is configurable through several options for
e.g. the verbosity of the logs.
See \link{whirl-options} on how to configure these.
}
\examples{
\dontshow{if (FALSE) (if (getRversion() >= "3.4") withAutoprint else force)(\{ # examplesIf}
# Copy example scripts:
file.copy(
  from = system.file("examples", c("success.R", "warning.R", "error.R"),
    package = "whirl"
  ),
  to = tempdir()
)

# Run a single script and create log:
run(file.path(tempdir(), "success.R"))

# Run several scripts in parallel on up to 2 workers:
run(
  input = file.path(tempdir(), c("success.R", "warning.R", "error.R")),
  n_workers = 2
)

# Run several scripts in two steps by providing them as list elements:
run(
  list(
    file.path(tempdir(), c("success.R", "warning.R")),
    file.path(tempdir(), "error.R")
  )
)

# Re-directing the logs to a sub-folder by utilizing the log_dir argument in
# run(). This will require that the sub-folder exists.

# Specifying the path using a manually defined character
run(file.path(tempdir(), "success.R"), log_dir = tempdir())

# Specifying the path with a generic function that can handle the scripts
# individually.
run(
  input = file.path(tempdir(), "success.R"),
  log_dir = function(x) {paste0(dirname(x), "/logs")}
)
\dontshow{\}) # examplesIf}
}
