\docType{package}
\name{whisker-package}
\alias{whisker-package}
\title{{{Mustache for R}}}
\description{
  Whisker is a templating engine for R confirming to the
  Mustache specification. Mustache is a logicless
  templating language, meaning that no programming source
  code can be used in your templates. This may seem very
  limited, but Mustache is nonetheless powerful and has the
  advantage of being able to be used unaltered in many
  programming languages. For example it make it very easy
  to write a web application in R using Mustache templates
  and where the browser can template using javascript's
  "Mustache.js"
}
\details{
  Mustache (and therefore \code{whisker}) takes a simple
  but different approach to templating compared to most
  templating engines. Most templating library for example
  \code{Sweave}, \code{brew} allow the user to mix
  programming code and text throughout the template. This
  is powerful, but ties a template directly to a
  programming language. Furthermore it make it difficult to
  seperate programming code from templating code.

  Whisker on the other hand, takes a Mustache template and
  uses the variables of the current environment (or the
  supplied \code{list}' to fill in the variables).
}
\examples{
template <- 
'Hello {{name}}
You have just won ${{value}}!
{{#in_ca}}
Well, ${{taxed_value}}, after taxes.
{{/in_ca}}'

data <- list( name = "Chris"
            , value = 10000
            , taxed_value = 10000 - (10000 * 0.4)
            , in_ca = TRUE
            )

whisker.render(template, data)




base <-
'<h2>Names</h2>
{{#names}}
  {{> user}}
{{/names}}'

user <- '<strong>{{name}}</strong>'

names <- list(list(name="Alice"), list(name="Bob"))

whisker.render(base, partials=list(user=user))

}

