% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/image_analysis.R
\name{wbt_normalized_difference_index}
\alias{wbt_normalized_difference_index}
\title{Normalized difference index}
\usage{
wbt_normalized_difference_index(
  input1,
  input2,
  output,
  clip = 0,
  correction = 0,
  wd = NULL,
  verbose_mode = FALSE,
  compress_rasters = FALSE,
  command_only = FALSE
)
}
\arguments{
\item{input1}{Input image 1 (e.g. near-infrared band).}

\item{input2}{Input image 2 (e.g. red band).}

\item{output}{Output raster file.}

\item{clip}{Optional amount to clip the distribution tails by, in percent.}

\item{correction}{Optional adjustment value (e.g. 1, or 0.16 for the optimal soil adjusted vegetation index, OSAVI).}

\item{wd}{Changes the working directory.}

\item{verbose_mode}{Sets verbose mode. If verbose mode is \code{FALSE}, tools will not print output messages.}

\item{compress_rasters}{Sets the flag used by 'WhiteboxTools' to determine whether to use compression for output rasters.}

\item{command_only}{Return command that would be executed by \code{system()} rather than running tool.}
}
\value{
Returns the tool text outputs.
}
\description{
Calculate a normalized-difference index (NDI) from two bands of multispectral image data.
}
\keyword{ImageProcessingTools}
