% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/wp_date_functions.r
\name{wp_date}
\alias{wp_date}
\alias{wp_date.character}
\alias{wp_date.default}
\alias{wp_date.numeric}
\alias{wp_date.dates}
\alias{wp_date.factor}
\alias{wp_date.POSIXct}
\alias{wp_date.POSIXlt}
\title{Package specific 'as.Date()' function}
\usage{
wp_date(x, ...)

\method{wp_date}{character}(x, format = "", ...)

\method{wp_date}{default}(x, ...)

\method{wp_date}{numeric}(x, origin, ...)

\method{wp_date}{dates}(x, ...)

\method{wp_date}{factor}(x, ...)

\method{wp_date}{POSIXct}(x, tz = "UTC", ...)

\method{wp_date}{POSIXlt}(x, ...)
}
\arguments{
\item{x}{See \code{?as.Date}}

\item{...}{See \code{?as.Date}}

\item{format}{See \code{?as.Date}}

\item{origin}{See \code{?as.Date}}

\item{tz}{See \code{?as.Date}}
}
\description{
\code{wp_date()} provides a generic function and several methods to transform
something into a date, just like \code{as.Date()} from the base package.
While most methods were copied 1:1 from as.Date() some changes were made that
alter  the usual behavior: (1) Whenever wp_date() is applied to an empty
string \code{""} or any other not-standard-unambiguous format the function
will return \code{NA} and throw out a warning instead of simply kill itself
with an error. (2) Whenever, as.Date usually is in the need of an origin
supplied and does not get one \code{wp_date()} will assume the origin to be
"1970-01-01" and throw an error instead of kill itself with an error. All
these changes are made with the special purpose to make \code{wp_trend()}
also with dirty, unreasonable data (e.g. "" or "2012-13-01" or "2012-02-32")
and are not recommended for any other than wikipediatrend internal use.
}
\section{Methods (by class)}{
\itemize{
\item \code{character}: Difference to \code{as.Date.character()}: Failing to
parse the date, \code{wp_date()} will give return a warning and \code{NA}
instead of killing itself with an error.

\item \code{default}: same as \code{as.Date()}

\item \code{numeric}: Difference to \code{as.Date.character()}: Whenever an 
origin is needed but not supplied instead of breaking, \code{wp_date()} 
will raise a warning and proceed by assuming "1970-01-01" to be the origin 
instead of killing itself with an error.

\item \code{dates}: same as \code{as.Date()}

\item \code{factor}: same as \code{as.Date()}

\item \code{POSIXct}: same as \code{as.Date()}

\item \code{POSIXlt}: using \code{as.Date()}
}}

