% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/prop-query-type.R
\name{query_by_}
\alias{query_by_}
\alias{query_by_title}
\alias{query_by_pageid}
\alias{query_by_revid}
\title{Query the \href{https://www.mediawiki.org/wiki/API:Main_page}{MediaWiki Action API} using a vector of
Wikipedia pages}
\usage{
query_by_title(.req, title)

query_by_pageid(.req, pageid)

query_by_revid(.req, revid)
}
\arguments{
\item{.req}{A \link{wiki_action_request} query to modify}

\item{title}{A character vector of page titles}

\item{pageid}{A character or numeric vector of page ids}

\item{revid}{A character or numeric vector of revision ids}
}
\value{
A request object of type \code{pages/query/action_api/httr2_request}. To
perform the query, pass the object to \link{next_batch} or \link{retrieve_all}
}
\description{
These functions help you to build a query for the \href{https://www.mediawiki.org/wiki/API:Main_page}{MediaWiki Action API} if you already have a set
of pages that you wish to investigate. These functions can be combined with
\link{query_page_properties} to choose which properties to return for the passed
pages.
}
\details{
If you don't already know which pages you wish to examine, you can build a
query to find pages that meet certain criteria using \link{query_list_pages} or
\link{query_generate_pages}.
}
\examples{
# Retrieve the categories for Charles Harpur's Wikipedia page
 resp <- wiki_action_request() \%>\%
  query_by_title("Charles Harpur") \%>\%
  query_page_properties("categories") \%>\%
  next_batch()
}
