% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot_wildmeta.R
\name{plot.Wald_test_wildmeta}
\alias{plot.Wald_test_wildmeta}
\title{Plot distribution of bootstrap test statistics}
\usage{
\method{plot}{Wald_test_wildmeta}(x, ...)
}
\arguments{
\item{x}{Results from Wald_test_cwb function}

\item{...}{Any other arguments to be passed to \code{ggplot2::geom_density()}}
}
\value{
A ggplot2 density plot.
}
\description{
Creates a density plot showing the distribution of bootstrap test statistics.
}
\examples{
data("SATcoaching", package = "clubSandwich")
library(clubSandwich)
library(robumeta)

full_model <- robu(d ~ 0 + study_type + hrs + test,
                   studynum = study,
                   var.eff.size = V,
                   small = FALSE,
                   data = SATcoaching)


res <- Wald_test_cwb(full_model = full_model,
                     constraints = constrain_equal(1:3),
                     R = 99)

if (requireNamespace("ggplot2", quietly = TRUE)) {
plot(res, fill = "darkred", alpha = 0.5)
}

}
