% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/secondDerivative.R
\name{secondDerivative}
\alias{secondDerivative}
\title{secondDerivative}
\usage{
secondDerivative(loc, FUN, ..., eps = 1e-07)
}
\arguments{
\item{loc}{The location (a vector) where the second derivatives
of \code{FUN} are desired.}

\item{FUN}{An R function to compute second derivatives for.
This must be a function of the form FUN <- function(x, ...){...}
where x is the parameters of the function (e.g., location \code{loc}).
\code{FUN} must return a single value (scalar), the height of the
surface above \code{x}, i.e., \code{FUN} evaluated at \code{x}.}

\item{...}{Additional agruments to \code{FUN}.}

\item{eps}{Radii argument, see details. Default is \code{10e-7}.}
}
\value{
Matrix
}
\description{
Computes numeric second derivatives (hessian) of an
arbitrary multidimensional function at a particular location.
}
\details{
This function uses the "5-point" numeric second derivative
method advocated in numerous numerical recipie texts.  During computation
of the second derivative, FUN will be evaluated
capable of evaluating at locations within a hyper-elipsoid
with cardinal radii \code{2*loc*(eps)^0.25}.


A handy way to use this function is to call an optimization routine
like \code{nlminb} with FUN, then call this function with the
optimized values (solution) and FUN.  This will yeild the hessian
at the solution rather than the hessian at the previous step of the
optimization.
}
\examples{

func <- function(x){-x*x} # second derivative should be -2
secondDerivative(0,func)
secondDerivative(3,func)

func <- function(x){3 + 5*x^2 + 2*x^3} # second derivative should be 10+12x
secondDerivative(0,func)
secondDerivative(2,func)

func <- function(x){x[1]^2 + 5*x[2]^2} # should be rbind(c(2,0),c(0,10))
secondDerivative(c(1,1),func)
secondDerivative(c(4,9),func)
}
