% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/visibility.R
\name{interpol_view}
\alias{interpol_view}
\title{interpol_view}
\usage{
interpol_view(res, plot = TRUE, breakseq, breakform = NULL,
  plotDEM = FALSE, fun = mean, ...)
}
\arguments{
\item{res}{The result list from viewshed.}

\item{plot}{Should the result be plotted? Default is TRUE}

\item{breakseq}{The breaks for value plotting. By default, 5 equal 
intervals are generated.}

\item{breakform}{If 'breakseq' is missing, a sampling function to 
calculate the breaks, like \code{\link{quantile}}, fivenum, etc.}

\item{plotDEM}{Plot the DEM? Default is FALSE}

\item{fun}{Function used for rasterize. Default is mean}

\item{...}{Arguments passed on to \code{\link[raster]{plot}}.}
}
\value{
An interpolated raster
}
\description{
Plot an interpolated view of the viewshed analysis
}
\examples{
\dontrun{
library(sp)
library(raster)
Polygon1 <- Polygon(rbind(c(4488182, 2667172), c(4488182, 2669343),
                          c(4499991, 2669343), c(4499991, 2667172)))
Polygon1 <- Polygons(list(Polygon1), 1);
Polygon1 <- SpatialPolygons(list(Polygon1))
Projection <- "+proj=laea +lat_0=52 +lon_0=10 +x_0=4321000 +y_0=3210000
+ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=m +no_defs"
proj4string(Polygon1) <- CRS(Projection)
DEM_meter <- getDEM(Polygon1)

sample_POI <- spsample(DEM_meter[[2]], n = ncell(DEM_meter[[1]]), 
                       type = "regular")
sample_xy <- coordinates(sample_POI)

turbloc = spsample(DEM_meter[[2]], 10, type = "random");
res <- viewshed(r = DEM_meter[[1]], shape=DEM_meter[[2]], 
                turbine_locs = turbloc,  h1=1.8, h2=50)
interpol_view(res, plotDEM = T)

interpol_view(res, breakseq = seq(0,max(colSums(res$Result)),1))
interpol_view(res, plotDEM = F, breakform = quantile)
interpol_view(res, breakform = factor)

## ... Arguments are past on to the raster plot method
interpol_view(res, plotDEM = T, alpha=0.5)
interpol_view(res, plotDEM = F, breakseq = seq(0,10,1), colNA="black")

}
}
\author{
Sebastian Gatscha
}
