% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/visibility.R
\name{getDEM}
\alias{getDEM}
\title{Get DEM raster}
\usage{
getDEM(polygon, ISO3 = "AUT", clip = TRUE)
}
\arguments{
\item{polygon}{A Spatial / SimpleFeature Polygon to crop the DEM}

\item{ISO3}{The ISO3 code of the country}

\item{clip}{boolean, indicating if polygon should be cropped. Default is TRUE}
}
\value{
A list with the DEM raster, and a Simple Feature Polygon or NULL if
  no polygon is given
}
\description{
Get a DEM raster for a country based on ISO3 code
}
\examples{
\dontrun{
library(sf)
library(raster)
Polygon1 <- sf::st_as_sf(sf::st_sfc(
  sf::st_polygon(list(cbind(
    c(4496482, 4496482, 4499991, 4499991, 4496482),
    c(2666272, 2669343, 2669343, 2666272, 2666272)))),
  crs = 3035
))
DEM_meter <- getDEM(Polygon1)
plot(DEM_meter[[1]])
plot(DEM_meter[[2]], add=TRUE)
}
}
\seealso{
Other Helper Functions: 
\code{\link{dup_coords}()},
\code{\link{getISO3}()},
\code{\link{get_grids}()},
\code{\link{grid_area}()},
\code{\link{hexa_area}()},
\code{\link{isSpatial}()},
\code{\link{permutations}()},
\code{\link{readintegerSel}()},
\code{\link{readinteger}()},
\code{\link{splitAt}()},
\code{\link{windata_format}()}
}
\concept{Helper Functions}
