% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/compat-data-frame.R, R/compat-sf.R
\name{wk_handle.data.frame}
\alias{wk_handle.data.frame}
\alias{wk_writer.data.frame}
\alias{wk_crs.data.frame}
\alias{wk_set_crs.data.frame}
\alias{wk_restore.data.frame}
\alias{wk_restore.tbl_df}
\alias{wk_translate.data.frame}
\alias{wk_translate.tbl_df}
\alias{wk_translate.sf}
\alias{wk_restore.sf}
\title{Use data.frame with wk}
\usage{
\method{wk_handle}{data.frame}(handleable, handler, ..., .env = parent.frame())

\method{wk_writer}{data.frame}(handleable, ...)

\method{wk_crs}{data.frame}(x)

\method{wk_set_crs}{data.frame}(x, crs)

\method{wk_restore}{data.frame}(handleable, result, ...)

\method{wk_restore}{tbl_df}(handleable, result, ...)

\method{wk_translate}{data.frame}(handleable, to, ..., .env = parent.frame())

\method{wk_translate}{tbl_df}(handleable, to, ..., .env = parent.frame())

\method{wk_translate}{sf}(handleable, to, ...)

\method{wk_restore}{sf}(handleable, result, ...)
}
\arguments{
\item{handleable}{A geometry vector (e.g., \code{\link[=wkb]{wkb()}}, \code{\link[=wkt]{wkt()}}, \code{\link[=xy]{xy()}},
\code{\link[=rct]{rct()}}, or \code{\link[sf:sfc]{sf::st_sfc()}}) for which \code{\link[=wk_handle]{wk_handle()}} is defined.}

\item{handler}{A \link[=wk_handle]{wk_handler} object.}

\item{...}{Passed to the \code{\link[=wk_handle]{wk_handle()}} method.}

\item{.env}{Passed to \code{\link[=getS3method]{getS3method()}}, which is used to find
the column in a \code{\link[=data.frame]{data.frame()}} for which a \code{\link[=wk_handle]{wk_handle()}}
method is defined.}

\item{x}{Objects whose "crs" attribute is used to carry a CRS.}

\item{crs}{An object that can be interpreted as a CRS}

\item{result}{The result of a filter operation intended to be a
transformation.}

\item{to}{A prototype object.}
}
\description{
Use data.frame with wk
}
\examples{
wk_handle(data.frame(a = wkt("POINT (0 1)")), wkb_writer())
wk_translate(wkt("POINT (0 1)"), data.frame(col_name = wkb()))
wk_translate(data.frame(a = wkt("POINT (0 1)")), data.frame(wkb()))

}
