% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/woe.binning.deploy.R
\name{woe.binning.deploy}
\alias{woe.binning.deploy}
\title{Deployment of Binning}
\usage{
woe.binning.deploy(df, binning, min.iv.total, add.woe.or.dum.var)
}
\arguments{
\item{df}{Name of data frame with input data.
The variable names and types (numerical or factor) need to be identical to
the ones used for generating the binning solution with the
\code{\link{woe.binning}} function.}

\item{binning}{Binning information generated from the \code{\link{woe.binning}} function.
Contains names of the input predictor variables and the
corresponding binning, WOE and IV information, which is used to
add a binned variable to a copy of the input data.}

\item{min.iv.total}{If the IV total value of a binned variable falls below this limit (e.g. 0.1)
it will not be added to the data. Just omit this parameter in case you would
like to add all binned variables (default).}

\item{add.woe.or.dum.var}{\emph{add.woe.or.dum.var=\dQuote{woe}} adds an additional variable with WOE scores
and \emph{=\dQuote{dum}} additional dummy variables for each (aggregated) level
of the binned variable. In case of dummy variables make sure that you have set
an appropriate \emph{abbrev.fact.levels} parameter in the \code{\link{woe.binning}} function
to avoid too long variable names. In principle, only alphanumeric characters
and dots (.) will be used for variable names. Just omit this parameter in case you
don't need additional variables.}
}
\description{
\code{woe.binning.deploy} applies the binning solution generated and saved via the \code{\link{woe.binning}} function to (new) data.
}
\details{
\code{woe.binning.deploy} applies the binning information generated from the \code{\link{woe.binning}}
function to a data frame. In this data frame the names of the variables
to be binned need to be identical to the ones used with the \code{woe.binning}
function. For each variable a binned version will be added. Optionally
a variable with associated weight of evidence (WOE) values or corresponding
dummy variables (one dummy variable for each final bin) are provided.
}
\section{Handling of Missing Data}{

In case NAs already occurred when generating the binning solution
via the \code{woe.binning} function the binning code 'Missing' is
displayed and a corresponding WOE value can be computed.
In case NAs only occur in the deployment scenario \sQuote{Missing} is
displayed for numeric variables and \sQuote{unknown} for factors; and
the corresponding WOE values will be NAs then, as well.
}

\section{Handling of Unknown Factor Levels}{

For factor levels that have not been provided in generating the
binning solution via the \code{woe.binning} function a new factor
level \sQuote{unknown} is displayed and the corresponding WOE value will be NA.
}
\examples{
# Load German credit data and create a subset
data(germancredit)
df <- germancredit[, c('creditability', 'credit.amount', 'duration.in.month',
                  'savings.account.and.bonds', 'purpose')]

# Bin all variables of the data frame (apart from the target variable)
# with default parameter settings
binning <- woe.binning(df, 'creditability', df)
					  
# Deploy the binning solution to the data frame
# (add all binned variables and corresponding WOE variables)
df.with.binned.vars.added <- woe.binning.deploy(df, binning,
                                               add.woe.or.dum.var='woe')		
					  
# Deploy the binning solution to the data frame
# (add binned variables with IV>=0.1 and corresponding dummy variables)
df.with.binned.vars.added <- woe.binning.deploy(df, binning,
                                               min.iv.total=0.1,
                                               add.woe.or.dum.var='dum')		

}
\seealso{
Other woe.binning.functions: \code{\link{woe.binning.plot}},
  \code{\link{woe.binning.table}},
  \code{\link{woe.binning}}
}

