% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/POST_PosteriorWij.R
\name{PosteriorAdj}
\alias{PosteriorAdj}
\title{PosteriorAdj}
\usage{
PosteriorAdj(object)
}
\arguments{
\item{object}{a \code{\link{STBDwDM}} model object for which predictions
are desired from.}
}
\value{
\code{PosteriorAdj} returns a matrix containing the following columns.

  \describe{

  \item{\code{i}}{Location \code{i} (i.e. which row/column on the adjacency matrix W).}

  \item{\code{j}}{Location \code{j} (i.e. which row/column on the adjacency matrix W).}

  \item{\code{DM}}{The dissimilarity metric between locations \code{i} and \code{j}.}

  \item{\code{meant}}{The posterior mean of the neighborhood adjacency between location
   \code{i} and \code{j} at time \code{t, t = 1, ... , Nu}.}

  \item{\code{sdt}}{The posterior mean of the neighborhood adjacency between location
   \code{i} and \code{j} at time \code{t, t = 1, ... , Nu}.}

  }
}
\description{
Calculates the posterior mean and standard deviation for the neighborhood adjacencies
 from the \code{\link{STBDwDM}} model.
}
\details{
The function \code{PosteriorAdj} calculates the posterior mean and standard
 deviation of the neighborhood adjacencies for each pairwise location. The neighborhood
 structure used to do this comes from Berchuck et al. 2017.
}
\author{
Samuel I. Berchuck
}

