% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/wflow_update.R
\name{wflow_update}
\alias{wflow_update}
\title{Update a workflowr project}
\usage{
wflow_update(dry_run = TRUE, project = ".")
}
\arguments{
\item{dry_run}{logical (default: TRUE). Preview the files to be updated.}

\item{project}{character (default: ".") By default the function assumes the
current working directory is within the project. If this is not true,
you'll need to provide the path to the project directory.}
}
\value{
A character vector of the updated files.
}
\description{
Update an existing workflowr project to workflowr 1.0.
}
\details{
By default, \code{wflow_update} is run in \code{dry_run} mode so that no
unwanted changes are made. Here's how to update an existing project to
workflowr 1.0:

\preformatted{
# Preview the files that will be updated
wflow_update()
# Update the files
wflow_update(dry_run = FALSE)
# Preview the updates
wflow_build()
# Publish the updates
wflow_publish("_workflowr.yml", "Update to 1.0", all = TRUE)
}

Currently \code{wflow_update} checks for the following items:

\itemize{

\item Adds the site generator \code{site: workflowr::wflow_site} to index.Rmd

\item Replaces \code{\link[rmarkdown]{html_document}} with
\code{workflowr::wflow_html} in _site.yml and the YAML header of the R
Markdown files

\item Deletes analysis/chunks.R

\item Removes the imported chunks in the R Markdown files

\item Adds a _workflowr.yml file, but does not change any of the options (so
that your site will continue to produce the same results)

\item Removes the workflowr line from include/footer.html (this is now
inserted automatically by \code{\link{wflow_html}})

}
}
\examples{
\dontrun{

# Preview the files to be udpated
wflow_update()
# Update the files
wflow_update(dry_run = FALSE)
}

}
