% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/predict.R
\name{predict-workflow}
\alias{predict-workflow}
\alias{predict.workflow}
\title{Predict from a workflow}
\usage{
\method{predict}{workflow}(object, new_data, type = NULL, opts = list(), ...)
}
\arguments{
\item{object}{A workflow that has been fit by \code{\link[=fit.workflow]{fit.workflow()}}}

\item{new_data}{A data frame containing the new predictors to preprocess
and predict on}

\item{type}{A single character value or \code{NULL}. Possible values
are "numeric", "class", "prob", "conf_int", "pred_int", "quantile",
or "raw". When \code{NULL}, \code{predict()} will choose an appropriate value
based on the model's mode.}

\item{opts}{A list of optional arguments to the underlying
predict function that will be used when \code{type = "raw"}. The
list should not include options for the model object or the
new data being predicted.}

\item{...}{Arguments to the underlying model's prediction
function cannot be passed here (see \code{opts}). There are some
\code{parsnip} related options that can be passed, depending on the
value of \code{type}. Possible arguments are:
\itemize{
\item \code{level}: for \code{type}s of "conf_int" and "pred_int" this
is the parameter for the tail area of the intervals
(e.g. confidence level for confidence intervals).
Default value is 0.95.
\item \code{std_error}: add the standard error of fit or
prediction for \code{type}s of "conf_int" and "pred_int".
Default value is \code{FALSE}.
\item \code{quantile}: the quantile(s) for quantile regression
(not implemented yet)
\item \code{time}: the time(s) for hazard probability estimates
(not implemented yet)
}}
}
\value{
A data frame of model predictions, with as many rows as \code{new_data} has.
}
\description{
This is the \code{predict()} method for a fit workflow object. The nice thing
about predicting from a workflow is that it will:
\itemize{
\item Preprocess \code{new_data} using the preprocessing method specified when the
workflow was created and fit. This is accomplished using
\code{\link[hardhat:forge]{hardhat::forge()}}, which will apply any formula preprocessing or call
\code{\link[recipes:bake]{recipes::bake()}} if a recipe was supplied.
\item Call \code{\link[parsnip:predict.model_fit]{parsnip::predict.model_fit()}} for you using the underlying fit
parsnip model.
}
}
\examples{
library(parsnip)
library(recipes)

training <- mtcars[1:20,]
testing <- mtcars[21:32,]

model <- linear_reg()
model <- set_engine(model, "lm")

workflow <- workflow()
workflow <- add_model(workflow, model)

recipe <- recipe(mpg ~ cyl + disp, training)
recipe <- step_log(recipe, disp)

workflow <- add_recipe(workflow, recipe)

fit_workflow <- fit(workflow, training)

# This will automatically `bake()` the recipe on `testing`,
# applying the log step to `disp`, and then fit the regression.
predict(fit_workflow, testing)
}
