% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/indicators.R
\name{wb_source}
\alias{wb_source}
\title{World Bank source data}
\source{
\url{https://api.worldbank.org/v2/sources}
}
\usage{
wb_source(source = NULL, lang = "en")
}
\arguments{
\item{source}{(\code{NULL} | \code{character()})\cr
Source to query. Default \code{NULL}. If \code{NULL}, all sources are returned.}

\item{lang}{(\code{character(1)})\cr
Language to query. Default \code{"en"}.}
}
\value{
A \code{data.frame()} with the available sources. The columns are:
\item{id}{The source ID.}
\item{last_updated}{The date the source was last updated.}
\item{name}{The source name.}
\item{code}{The source code.}
\item{description}{The source description.}
\item{url}{The source URL.}
\item{data_availability}{Whether the source has data available.}
\item{metadata_availability}{Whether the source has metadata available.}
\item{concepts}{The concepts associated with the source.}
}
\description{
List all sources supported by the World Bank API.
}
\examples{
\dontshow{if (httr2::is_online()) withAutoprint(\{ # examplesIf}
src <- wb_source()
head(src)
\dontshow{\}) # examplesIf}
}
\seealso{
Other indicators data: 
\code{\link{wb_country}()},
\code{\link{wb_income_level}()},
\code{\link{wb_indicator}()},
\code{\link{wb_language}()},
\code{\link{wb_lending_type}()},
\code{\link{wb_region}()},
\code{\link{wb_topic}()}
}
\concept{indicators data}
