% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/metNOAA.R
\name{importNOAA}
\alias{importNOAA}
\title{Import Meteorological data from the NOAA Integrated Surface Database (ISD)}
\usage{
importNOAA(
  code = "037720-99999",
  year = 2014,
  hourly = TRUE,
  n.cores = 1,
  quiet = FALSE,
  path = NA
)
}
\arguments{
\item{code}{The identifying code as a character string. The code is a
combination of the USAF and the WBAN unique identifiers. The codes are
separated by a \dQuote{-} e.g. \code{code = "037720-99999"}.}

\item{year}{The year to import. This can be a vector of years e.g. \code{year = 2000:2005}.}

\item{hourly}{Should hourly means be calculated? The default is \code{TRUE}. If
\code{FALSE} then the raw data are returned.}

\item{n.cores}{Number of cores to use for parallel processing. Default is 1
and hence no parallelism.}

\item{quiet}{If FALSE, print missing sites / years to the screen.}

\item{path}{If a file path is provided, the data are saved as an rds file at
the chosen location e.g.  \code{path = "C:/Users/David"}. Files are saved by
year and site.}
}
\value{
Returns a data frame of surface observations. The data frame is
consistent for use with the \code{openair} package. Note that the data are
returned in GMT (UTC) time zone format. Users may wish to express the data
in other time zones, e.g., to merge with air pollution data. The
\link[lubridate:lubridate-package]{lubridate} package is useful in this
respect.
}
\description{
This is the main function to import data from the NOAA Integrated Surface
Database (ISD). The ISD contains detailed surface meteorological data from
around the world for over 30,000 locations.
}
\details{
Note the following units for the main variables:

\describe{

\item{date}{Date/time in POSIXct format. \strong{Note the time zone is GMT (UTC)
and may need to be adjusted to merge with other local data. See details
below.}}

\item{latitude}{Latitude in decimal degrees (-90 to 90).}

\item{longitude}{Longitude in decimal degrees (-180 to 180). Negative numbers
are west of the Greenwich Meridian.}

\item{elevation}{Elevation of site in metres.}

\item{wd}{Wind direction in degrees. 90 is from the east.}

\item{ws}{Wind speed in m/s.}

\item{ceil_hgt}{The height above ground level (AGL) of the lowest cloud or
obscuring phenomena layer aloft with 5/8 or more summation total sky cover,
which may be predominantly opaque, or the vertical visibility into a
surface-based obstruction.}

\item{visibility}{The visibility in metres.}

\item{air_temp}{Air temperature in degrees Celcius.}

\item{dew_point}{The dew point temperature in degrees Celcius.}

\item{atmos_pres}{The sea level pressure in millibars.}

\item{RH}{The relative humidity (\%).}

\item{cl_1,  ...,  cl_3}{Cloud cover for different layers in Oktas (1-8).}

\item{cl}{Maximum of cl_1 to cl_3 cloud cover in Oktas (1-8).}

\item{cl_1_height, ..., cl_3_height}{Height of the cloud base for each later
in metres.}

\item{precip_12}{12-hour precipitation in mm. The sum of this column should
give the annual precipitation.}

\item{precip_6}{6-hour precipitation in mm.}

\item{precip}{This value of precipitation spreads the 12-hour total across
the previous 12 hours.}

\item{pwc}{The description of the present weather description (if
available).}

}

The data are returned in GMT (UTC). It may be necessary to adjust the time
zone when combining with other data. For example, if air quality data were
available for Beijing with time zone set to "Etc/GMT-8" (note the negative
offset even though Beijing is ahead of GMT. See the \code{openair} package and
manual for more details), then the time zone of the met data can be changed
to be the same. One way of doing this would be \code{attr(met$date, "tzone") <- "Etc/GMT-8"} for a meteorological data frame called \code{met}. The two data sets
could then be merged based on \code{date}.
}
\examples{

\dontrun{
## use Beijing airport code (see getMeta example)
dat <- importNOAA(code = "545110-99999", year = 2010:2011)
}
}
\seealso{
\code{\link[=getMeta]{getMeta()}} to obtain the codes based on various site search
approaches.
}
\author{
David Carslaw
}
