% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/identify_shifts.R
\name{identify_shifts}
\alias{identify_shifts}
\title{Identify shifts based on outlook time settings for work day start and end
time}
\usage{
identify_shifts(data, return = "plot")
}
\arguments{
\item{data}{A data frame containing data from the Hourly Collaboration query.}

\item{return}{String specifying what to return. This must be one of the
following strings:
\itemize{
\item \code{"plot"}
\item \code{"table"}
\item \code{"data"}
}

See \code{Value} for more information.}
}
\value{
A different output is returned depending on the value passed to the \code{return}
argument:
\itemize{
\item \code{"plot"}: ggplot object. A bar plot for the weekly count of shifts.
\item \code{"table"}: data frame. A summary table for the count of shifts.
\item \verb{"data}: data frame. Input data appended with the \code{Shifts} columns.
}
}
\description{
This function uses outlook calendar settings for start and end time of work
day to identify work shifts. The relevant variables are
\code{WorkingStartTimeSetInOutlook} and \code{WorkingEndTimeSetInOutlook}.
}
\examples{
# Return plot
dv_data \%>\% identify_shifts()

# Return summary table
dv_data \%>\% identify_shifts(return = "table")

}
\seealso{
Other Data Validation: 
\code{\link{check_query}()},
\code{\link{extract_hr}()},
\code{\link{flag_ch_ratio}()},
\code{\link{flag_em_ratio}()},
\code{\link{flag_extreme}()},
\code{\link{flag_outlooktime}()},
\code{\link{hr_trend}()},
\code{\link{hrvar_count_all}()},
\code{\link{hrvar_count}()},
\code{\link{identify_churn}()},
\code{\link{identify_holidayweeks}()},
\code{\link{identify_inactiveweeks}()},
\code{\link{identify_nkw}()},
\code{\link{identify_outlier}()},
\code{\link{identify_privacythreshold}()},
\code{\link{identify_query}()},
\code{\link{identify_shifts_wp}()},
\code{\link{identify_tenure}()},
\code{\link{remove_outliers}()},
\code{\link{standardise_pq}()},
\code{\link{subject_validate_report}()},
\code{\link{subject_validate}()},
\code{\link{track_HR_change}()},
\code{\link{validation_report}()}

Other Working Patterns: 
\code{\link{flex_index}()},
\code{\link{identify_shifts_wp}()},
\code{\link{plot_flex_index}()},
\code{\link{workpatterns_area}()},
\code{\link{workpatterns_classify_bw}()},
\code{\link{workpatterns_classify_pav}()},
\code{\link{workpatterns_classify}()},
\code{\link{workpatterns_hclust}()},
\code{\link{workpatterns_rank}()},
\code{\link{workpatterns_report}()}
}
\concept{Data Validation}
\concept{Working Patterns}
