% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/workpatterns_area.R
\name{workpatterns_area}
\alias{workpatterns_area}
\title{Create an area plot of emails and IMs by hour of the day}
\usage{
workpatterns_area(
  data,
  hrvar = "Organization",
  mingroup = 5,
  signals = c("email", "IM"),
  return = "plot",
  values = "percent",
  start_hour = "0900",
  end_hour = "1700"
)
}
\arguments{
\item{data}{A data frame containing data from the Hourly Collaboration query.}

\item{hrvar}{HR Variable by which to split metrics. Accepts a character
vector, defaults to \code{"Organization"} but accepts any character vector, e.g.
\code{"LevelDesignation"}}

\item{mingroup}{Numeric value setting the privacy threshold / minimum group
size, defaults to 5.}

\item{signals}{Character vector to specify which collaboration metrics to
use:
\itemize{
\item a combination of signals, such as \code{c("email", "IM")} (default)
\item \code{"email"} for emails only
\item \code{"IM"} for Teams messages only
\item \code{"unscheduled_calls"} for Unscheduled Calls only
\item \code{"meetings"} for Meetings only
}}

\item{return}{String specifying what to return. This must be one of the
following strings:
\itemize{
\item \code{"plot"}
\item \code{"table"}
}

See \code{Value} for more information.}

\item{values}{Character vector to specify whether to return percentages
or absolute values in "data" and "plot". Valid values are:
\itemize{
\item \code{"percent"}: percentage of signals divided by total signals (default)
\item \code{"abs"}: absolute count of signals
}}

\item{start_hour}{A character vector specifying starting hours,
e.g. "0900"}

\item{end_hour}{A character vector specifying starting hours,
e.g. "1700"}
}
\value{
A different output is returned depending on the value passed to the \code{return}
argument:
\itemize{
\item \code{"plot"}: ggplot object. An overlapping area plot (default).
\item \code{"table"}: data frame. A summary table.
}
}
\description{
Uses the Hourly Collaboration query to produce an area plot of
Emails sent and IMs sent attended by hour of the day.
}
\examples{
# Return visualization of percentage distribution
workpatterns_area(em_data, return = "plot", values = "percent")

# Return visualization of absolute values
workpatterns_area(em_data, return = "plot", values = "abs")

# Return summary table
workpatterns_area(em_data, return = "table")

}
\seealso{
Other Visualization: 
\code{\link{afterhours_dist}()},
\code{\link{afterhours_fizz}()},
\code{\link{afterhours_line}()},
\code{\link{afterhours_rank}()},
\code{\link{afterhours_summary}()},
\code{\link{afterhours_trend}()},
\code{\link{collaboration_area}()},
\code{\link{collaboration_dist}()},
\code{\link{collaboration_fizz}()},
\code{\link{collaboration_line}()},
\code{\link{collaboration_rank}()},
\code{\link{collaboration_sum}()},
\code{\link{collaboration_trend}()},
\code{\link{create_bar_asis}()},
\code{\link{create_bar}()},
\code{\link{create_boxplot}()},
\code{\link{create_bubble}()},
\code{\link{create_dist}()},
\code{\link{create_fizz}()},
\code{\link{create_line_asis}()},
\code{\link{create_line}()},
\code{\link{create_period_scatter}()},
\code{\link{create_rank}()},
\code{\link{create_sankey}()},
\code{\link{create_scatter}()},
\code{\link{create_stacked}()},
\code{\link{create_trend}()},
\code{\link{email_dist}()},
\code{\link{email_fizz}()},
\code{\link{email_line}()},
\code{\link{email_rank}()},
\code{\link{email_summary}()},
\code{\link{email_trend}()},
\code{\link{external_network_plot}()},
\code{\link{hr_trend}()},
\code{\link{hrvar_count}()},
\code{\link{internal_network_plot}()},
\code{\link{keymetrics_scan}()},
\code{\link{meeting_dist}()},
\code{\link{meeting_fizz}()},
\code{\link{meeting_line}()},
\code{\link{meeting_quality}()},
\code{\link{meeting_rank}()},
\code{\link{meeting_summary}()},
\code{\link{meeting_trend}()},
\code{\link{meetingtype_dist_ca}()},
\code{\link{meetingtype_dist_mt}()},
\code{\link{meetingtype_dist}()},
\code{\link{meetingtype_summary}()},
\code{\link{mgrcoatt_dist}()},
\code{\link{mgrrel_matrix}()},
\code{\link{one2one_dist}()},
\code{\link{one2one_fizz}()},
\code{\link{one2one_freq}()},
\code{\link{one2one_line}()},
\code{\link{one2one_rank}()},
\code{\link{one2one_sum}()},
\code{\link{one2one_trend}()},
\code{\link{period_change}()},
\code{\link{workloads_dist}()},
\code{\link{workloads_fizz}()},
\code{\link{workloads_line}()},
\code{\link{workloads_rank}()},
\code{\link{workloads_summary}()},
\code{\link{workloads_trend}()},
\code{\link{workpatterns_rank}()}

Other Working Patterns: 
\code{\link{flex_index}()},
\code{\link{identify_shifts_wp}()},
\code{\link{identify_shifts}()},
\code{\link{plot_flex_index}()},
\code{\link{workpatterns_classify_bw}()},
\code{\link{workpatterns_classify_pav}()},
\code{\link{workpatterns_classify}()},
\code{\link{workpatterns_hclust}()},
\code{\link{workpatterns_rank}()},
\code{\link{workpatterns_report}()}

Other Working Patterns: 
\code{\link{flex_index}()},
\code{\link{identify_shifts_wp}()},
\code{\link{identify_shifts}()},
\code{\link{plot_flex_index}()},
\code{\link{workpatterns_classify_bw}()},
\code{\link{workpatterns_classify_pav}()},
\code{\link{workpatterns_classify}()},
\code{\link{workpatterns_hclust}()},
\code{\link{workpatterns_rank}()},
\code{\link{workpatterns_report}()}
}
\concept{Visualization}
\concept{Working Patterns}
