% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/wqs_full_perm.R
\name{wqs_full_perm}
\alias{wqs_full_perm}
\title{Full wrapper WQS permutation test}
\usage{
wqs_full_perm(
  formula,
  data,
  mix_name,
  q = 10,
  b_main = 1000,
  b_perm = 200,
  b1_pos = TRUE,
  b1_constr = FALSE,
  rs = FALSE,
  niter = 200,
  seed = NULL,
  family = "gaussian",
  plan_strategy = "multicore",
  stop_if_nonsig = FALSE,
  stop_thresh = 0.05,
  ...
)
}
\arguments{
\item{formula}{An object of class formula. The wqs term must be included in
the formula (e.g., y ~ wqs + ...).}

\item{data}{The \code{data.frame} to be used in the WQS regression run.}

\item{mix_name}{A vector with the mixture column names.}

\item{q}{An integer to indicate the number of quantiles to split the mixture
variables.}

\item{b_main}{The number of bootstraps for the main WQS regression run.}

\item{b_perm}{The number of bootstraps for the iterated permutation test
WQS regression runs and the reference WQS regression run (only for linear
WQS regression and only when b_mean != b_perm).}

\item{b1_pos}{A logical value that indicates whether beta values should be
positive or negative.}

\item{b1_constr}{Logical value that determines whether to apply positive or
negative constraints in the optimization function for the weight optimization.}

\item{rs}{A logical value indicating whether random subset implementation
should be performed.}

\item{niter}{Number of permutation test iterations.}

\item{seed}{An integer to fix the seed. This will only impact the the initial
WQS regression run and not the permutation test iterations. The default
setting is NULL, which means no seed is used for the initial WQS regression.
The seed will be saved in the "gwqs_main" object as "gwqs_main$seed".}

\item{family}{A description of the error distribution and link function to be
used in the model. This can be a character string naming a family function
(e.g., "binomial") or a family object (e.g., binomial(link="logit")).
Currently validated families include gaussian(link="identity") for linear
regression, binomial() with any accepted link function (e.g., "logit" or
"probit"), poisson(link = "log"), quasipoisson(link = "log"), or "negbin" for
negative binomial. The "multinomial" family is not yet supported.}

\item{plan_strategy}{Evaluation strategy for the plan function. You can choose
among "sequential", "transparent", "multisession", "multicore", "multiprocess",
"cluster" and "remote." See future::plan documentation for full details.}

\item{stop_if_nonsig}{if TRUE, the function will not proceed with the
permutation test if the main WQS regression run produces nonsignificant
p-value.}

\item{stop_thresh}{numeric p-value threshold required in order to proceed
with the permutation test, if \code{stop_if_nonsig = TRUE}.}

\item{...}{Other parameters to put into the gwqs function call.}
}
\value{
\code{wqs_full_perm} returns an object of class \code{wqs_perm}, which
contains three sublists:

\item{perm_test}{List containing: (1) \code{pval}: permutation test p-value, (2) (linear
regression only) \code{testbeta1}: reference WQS regression coefficient beta1 value, (3)
(linear regression only) \code{betas}: Vector of beta values from each
permutation test run, (4) (logistic regression only) \code{testpval}: test reference
p-value, (5) (logistic regression only) \code{permpvals}: p-values from the null
models.}
\item{gwqs_main}{Main gWQS object (same as model input). This will now include an
additional object "seed" that returns the seed used for this main WQS regression.}
\item{gwqs_perm}{Permutation test reference gWQS object (NULL if model
\code{family != "gaussian"} or if same number of bootstraps are used in permutation
test WQS regression runs as in the main run).}
}
\description{
\code{wqs_full_perm} is a full wrapper function that is a full implementation
of the Weighted Quantile Sum (WQS) regression method followed by the
permutation test to determine the significance of the WQS coefficient.
}
\examples{
library(gWQS)

# mixture names
PCBs <- names(wqs_data)[1:17] #half of the original 34 for quick computation

perm_test_res <- wqs_full_perm(formula = yLBX ~ wqs, data = wqs_data, 
                                mix_name = PCBs, q = 10, b_main = 5, 
                                b_perm = 5, b1_pos = TRUE, b1_constr = FALSE, 
                                niter = 3, seed = 16, plan_strategy = "multicore", 
                                stop_if_nonsig = FALSE)

# Note: The default values of b_main = 1000, b_perm = 200, and niter = 200 
# are the recommended parameter values. This example has a lower b_main, 
# b_perm, and niter in order to serve as a shorter test run. 
 
}
