% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/anlz_prdmatrix.R
\name{anlz_prdmatrix}
\alias{anlz_prdmatrix}
\title{Get prediction matrix for a fitted GAM}
\usage{
anlz_prdmatrix(mod, doystr = 1, doyend = 364, avemat = FALSE)
}
\arguments{
\item{mod}{input model object as returned by \code{\link{anlz_gam}}}

\item{doystr}{numeric indicating start Julian day for extracting averages}

\item{doyend}{numeric indicating ending Julian day for extracting averages}

\item{avemat}{logical indicating if the prediction matrix is to be passed to \code{anlz_metseason} (default) or \code{anlz_avgseason}}
}
\value{
a \code{data.frame} with predictors to use with the fitted GAM
}
\description{
Get prediction matrix for a fitted GAM
}
\details{
Used internally by \code{\link{anlz_metseason}}, not to be used by itself
}
\examples{
library(dplyr)

# data to model
tomod <- rawdat \%>\%
  filter(station \%in\% 34) \%>\%
  filter(param \%in\% 'chl') \%>\% 
  filter(yr > 2015)
  
mod <- anlz_gam(tomod, trans = 'log10')
anlz_prdmatrix(mod, doystr = 90, doyend = 180)
}
\concept{analyze}
