% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/colMedSds.R
\name{colMedSds}
\alias{colMedSds}
\title{Standard error of median for each column by bootstrap}
\usage{
colMedSds(dat, nBoot = 99, silent = FALSE, callFrom = NULL)
}
\arguments{
\item{dat}{(numeric) matix}

\item{nBoot}{(integer) number if iterations}

\item{silent}{(logical) suppress messages}

\item{callFrom}{(character) allow easier tracking of messages produced}
}
\value{
This function returns a (numeric) vector with estimated standard errors
}
\description{
Determine standard error (sd) of median by bootstraping for multiple sets of data (rows in input matrix 'dat').
Note: The package \href{https://CRAN.R-project.org/package=boot}{boot} must be installed from CRAN.
}
\examples{
set.seed(2016); dat1 <- matrix(c(runif(200) +rep(1:10,20)), ncol=10)
colMedSds(dat1) 
}
\seealso{
\code{\link[boot]{boot}}
}
