% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/countSameStartEnd.R
\name{countSameStartEnd}
\alias{countSameStartEnd}
\title{Count same start- and end- sites of edges (or fragments)}
\usage{
countSameStartEnd(frag, minFreq = 2, nDig = 4)
}
\arguments{
\item{frag}{(matrix) 1st column \code{beg} start-sites, 2nd column \code{end} end-sites of edges, rownames to precise fragment identities are recommended}

\item{minFreq}{(integer) min number of accumulated sites for taking into account (allows filtering with large datasets)}

\item{nDig}{(integer) rounding: number of digits for columns \code{beg.rat} and \code{end.rat} in output}
}
\value{
matrix of 6 columns: input (beg and end), beg.n, beg.rat, end.n, end.rat
}
\description{
Suppose a parent sequence/string 'ABCDE' gets cut in various fragments (eg 'ABC','AB' ...).   
\code{countSameStartEnd} counts how many (ie re-occuring) start- and end- sites of edges do occur in the input-data. 
The input is presented as matrix of/indicating start- and end-sites of edges.
The function is used to characterize partially redundant edges and accumulation of cutting/breakage sites.
}
\examples{
frag1 <- cbind(beg=c(2,3,7,13,13,15,7,9,7, 3,3,5), end=c(6,12,8,18,20,20,19,12,12, 4,5,7))
rownames(frag1) <- letters[1:nrow(frag1)]
countSameStartEnd(frag1)
simpleFragFig(frag1)
}
\seealso{
to build initial tree \code{\link{buildTree}}, \code{\link{contribToContigPerFrag}}, \code{\link{simpleFragFig}}
}
