% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/rowGrpSds.R
\name{.rowGrpSds}
\alias{.rowGrpSds}
\title{row group sd (main)}
\usage{
.rowGrpSds(x, grp)
}
\arguments{
\item{x}{numeric matrix where relplicates are organized into separate columns}

\item{grp}{(factor) defining which columns should be grouped (considered as replicates)}
}
\value{
This function returns a matrix of sd values per row and group of replicates
}
\description{
This function calculates sd for matrix with multiple groups of data, ie one sd for each group of data.
}
\examples{
set.seed(2016); dat1 <- matrix(c(runif(200)+rep(1:10,20)),ncol=10)
grp1 <- gl(4,3,labels=LETTERS[1:4])[2:11]
head(.rowGrpSds(dat1, grp1))
}
\seealso{
\code{\link{rowGrpCV}}, \code{\link{rowCVs}}, \code{\link{arrayCV}}, \code{\link{replPlateCV}}
}
