% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tableToPlot.R
\name{tableToPlot}
\alias{tableToPlot}
\title{Print matrix-content as plot}
\usage{
tableToPlot(
  matr,
  colPos = c(0.05, 0.35, 0.41, 0.56),
  useCex = 0.7,
  useAdj = c(0, 1, 1, 0),
  titOffS = 0,
  useCol = 1,
  silent = FALSE,
  callFrom = NULL
)
}
\arguments{
\item{matr}{(matrix) main (character) matrix to display}

\item{colPos}{(numeric) postion of columns on x-scale (from 0 to 1)}

\item{useCex}{(numeric) cex expension factor forsiez of text (may be different for each column)}

\item{useAdj}{(numeric) left/cneter/right alignment for text (may be different for each column)}

\item{titOffS}{(numeric) offset for title line (ralive to 'colPos')}

\item{useCol}{color specification for text (may be different for each column)}

\item{silent}{(logical) suppress messages}

\item{callFrom}{(character) allow easier tracking of message(s) produced}
}
\value{
NULL (no R-object returned), print 'plot' in current device only
}
\description{
\code{tableToPlot} prints all columns of matrix in plotting region for easier inclusion to reports (default values are set to work for output as A4-sized pdf).
This function was made for integrating listings of text to graphical output to devices like \code{png}, \code{jpeg} or \code{pdf}. 
This function was initially designed for listings with small/medium 1st col (eg couner or index), 2nd & 3rd col small and long 3rd col (like file paths).
Obviously, the final number of lines one can pack and still read correctly into the graphical output depends on the size of the device 
(on a pdf of size A4 one can pack up to apr. 11O lines). 
Of ourse, \code{\link[utils]{Sweave}}, combined with LaTeX, provides a powerful alternative for wrapping text to pdf-output (and further combining text and graphics).
Note: The final result on pdf devices may vary depending on screen-size (ie with of current device), the parameters 'colPos' and 'titOffS' may need some refinements.
Note: In view of typical page/figure layouts like A4, the plotting region will be split to avoid too wide spacing between rows with less than 30 rows.
}
\examples{
## as example let's make a listing of file-names and associated parameters in current directory
mat <- dir()
mat <- cbind(no=1:length(mat),fileName=mat,mode=file.mode(mat),
  si=round(file.size(mat)/1024),path=getwd())
## Now, we wrap all text into a figure (which could be saved as jpg etc)
tableToPlot(mat[,-1],colPos=c(0.01,0.4,0.46,0.6),titOffS=c(0.05,-0.03,-0.01,0.06))
tableToPlot(mat,colPos=c(0,0.16,0.36,0.42,0.75),useAdj=0.5,titOffS=c(-0.01,0,-0.01,0,-0.1)) 
}
\seealso{
\code{\link[utils]{Sweave}} for more flexible framework
}
