% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/checkGroupOrder.R
\name{checkGrpOrder}
\alias{checkGrpOrder}
\title{checkGrpOrder}
\usage{
checkGrpOrder(x, rankExp = NULL, revRank = TRUE)
}
\arguments{
\item{x}{matrix or data.frame}

\item{rankExp}{(numeric) expected order for values in columns, default 'rankExp' =1:ncol(x)}

\item{revRank}{(logical) if 'revRank'=TRUE, the initial ranks & reversed ranks will be tested}
}
\value{
vector of logical values
}
\description{
\code{checkGrpOrder} tests each line of 'x' if expected order appears. 
Used for comparing groups of measures with expected profile (simply by mataching expected order)
}
\examples{
set.seed(2005); mat <- matrix(round(runif(40),1),ncol=4)
checkGrpOrder(mat)
checkGrpOrder(mat,c(1,4,3,2))
}
\seealso{
\code{\link[wrMisc]{checkGrpOrderSEM}}
}
