% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/summarizeForROC.R
\name{summarizeForROC}
\alias{summarizeForROC}
\title{Summarize statistical test result for plotting ROC-curves}
\usage{
summarizeForROC(test, thr = NULL, tyThr = "BH", columnTest = 1,
  spec = c("H", "E", "S"), tit = NULL, color = 1, plotROC = TRUE,
  pch = 1, bg = NULL, overlPlot = FALSE, silent = FALSE,
  callFrom = NULL)
}
\arguments{
\item{test}{(class \code{MArrayLM}, S3-object from limma) from testing (eg \code{\link{testRobustToNAimputation}} or \code{\link{test2grp}}}

\item{thr}{(numeric) threshold, if \code{NULL} a panel of 108 values will be used for calculating specifcity and sensitivity}

\item{tyThr}{(character,length=1) type of test-result to be used for sensitivity and specificity calculations (eg 'BH','lfdr' or 'p.value'), must be list-element of 'test'}

\item{columnTest}{(character or integer) only in case 'tyThr' is matrix (as typically the case after \code{testRobustToNAimputation}) : which column of 'test$tyThr' should be used as test-result}

\item{spec}{(character) labels for species will be matched to column 'spec' of test$annot and used for sensitivity and specificity calculations. Important : 1st label for matrix (expected as constant) and subsequent labels for spike-ins (variable)}

\item{tit}{(character) optinal custom title in graph}

\item{color}{(character or integer) color in graph}

\item{plotROC}{(logical) toogle plot on or off}

\item{pch}{(integer) type of symbol to be used (see \code{\link[graphics]{par}})}

\item{bg}{(character) backgroud in plot (see \code{\link[graphics]{par}})}

\item{overlPlot}{(logical) overlay to existing plot if \code{TRUE}}

\item{silent}{(logical) suppress messages}

\item{callFrom}{(character) allows easier tracking of messages produced}
}
\value{
matrix including imputed values or list of final and matrix with number of imputed by group (plus optional plot)
}
\description{
\code{summarizeForROC} takes statistical testing results (obtained using \code{\link{testRobustToNAimputation}} or \code{\link[wrMisc]{moderTest2grp}}, based on \href{https://bioconductor.org/packages/release/bioc/html/limma.html}{limma}) and calculates specifcity and sensitivity values for plotting ROC-curves along a panel of thresholds.  
Based on column from test$annot and argumnet 'spec' TP,FP,FN and TN are determined.   
See also \href{https://en.wikipedia.org/wiki/Receiver_operating_characteristic}{ROC on Wkipedia} for explanations of TP,FP,FN and TN as well as examples.
An optional plot may be produced, too.
Return matrix with TP,FP,FN,TN,spec,sens,prec,accur and FDR count values along the various thrsholds specified in column 'alph'.
}
\examples{
set.seed(2019); test1 <- list(annot=cbind(spec=c(rep("b",35),letters[sample.int(n=3,
  size=150,replace=TRUE)])),BH=matrix(c(runif(35,0,0.01),runif(150)),ncol=1))
tail(roc1 <- summarizeForROC(test1,spec=c("a","b","c")))

}
\seealso{
\code{\link{testRobustToNAimputation}}, \code{\link[wrMisc]{moderTest2grp}}, \code{\link{test2grp}}, \code{\link[limma]{eBayes}}, \code{\link[stats]{t.test}}
}
