% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plotmag.R
\name{plotmag}
\alias{plotmag}
\alias{plotmag.tts}
\alias{plotmag.wt}
\alias{plotmag.wmf}
\alias{plotmag.wpmf}
\alias{plotmag.coh}
\alias{plotmag.wlmtest}
\alias{plotmag.default}
\title{For plotting the magnitude of values in \code{tts}, \code{coh} and \code{wlmtest} objects}
\usage{
plotmag(object, ...)

\method{plotmag}{tts}(object, zlims = NULL, neat = TRUE, colorfill = NULL,
  colorbar = TRUE, title = NULL, filename = NA, ...)

\method{plotmag}{wt}(object, zlims = NULL, neat = TRUE, colorfill = NULL,
  colorbar = TRUE, title = NULL, filename = NA, ...)

\method{plotmag}{wmf}(object, zlims = NULL, neat = TRUE, colorfill = NULL,
  colorbar = TRUE, title = NULL, filename = NA, ...)

\method{plotmag}{wpmf}(object, zlims = NULL, neat = TRUE,
  colorfill = NULL, sigthresh = 0.95, colorbar = TRUE, title = NULL,
  filename = NA, ...)

\method{plotmag}{coh}(object, sigthresh = c(0.95, 0.99), bandprows = "all",
  filename = NA, ...)

\method{plotmag}{wlmtest}(object, sigthresh = c(0.95, 0.99),
  bandprows = "all", filename = NA, ...)

\method{plotmag}{default}(object, ...)
}
\arguments{
\item{object}{An object of class \code{tts} or some class that inherits from \code{tts} or 
of class \code{coh} or \code{wlmtest}}

\item{...}{Additional graphics parameters passed to \code{image} (\code{graphics} package) 
if \code{colorbar==FALSE}, or to \code{image.plot} (\code{fields} package) if 
\code{colorbar==TRUE} (for \code{tts} objects)}

\item{zlims}{z axis limits. If specified, must encompass the range of 
\code{Mod(get_values(object))}. Default NULL uses this range.}

\item{neat}{Logical. Should timescales with no values be trimmed?}

\item{colorfill}{Color spectrum to use, set through colorRampPalette. Default value NULL 
produces jet colors from Matlab.}

\item{colorbar}{Logical. Should a colorbar legend be plotted?}

\item{title}{Title for the top of the plot.}

\item{filename}{Filename (without extension), for saving as pdf. Default value NA saves no 
file and uses the default graphics device.}

\item{sigthresh}{Significance threshold(s). Numeric vector with values between 0 and 1. 
Typically 0.95, 0.99, 0.999, etc. For \code{wpmf} objects, contours are plotted at these 
values; for \code{coh} and \code{wlmtest} objects the threshholds are plotted on coherence 
plots.}

\item{bandprows}{The rows of \code{object$bandp} for which to display results in \code{coh} plots}
}
\description{
For plotting the magnitude of values in \code{tts} objects (and derived classes) 
against time and timescale, and \code{coh} and \code{wlmtest} objects against timescale
}
\details{
For \code{coh} (respectively, \code{wlmtest}) objects, the modulus of 
object$coher (respectively, object$wlmobj$coher) is plotted using a solid red line, and 
the modulus of object$signif$coher is plotted using a dashed red line. The two coherences 
agree except for \code{sigmethod="fast"}, for which they are close. The dashed line is what 
should be compared to the distribution of surrogate coherences (black lines, which only appear 
for \code{coh} objects if \code{signif} is not \code{NA}). Horizontal axis ticks are labeled 
as timescales, but are spaced on the axis as log(1/timescale), i.e., log frequencies.
}
\examples{
#For a wt object
time1<-1:100
time2<-101:200
ts1p1<-sin(2*pi*time1/15)
ts1p2<-0*time1
ts2p1<-0*time2
ts2p2<-sin(2*pi*time2/8)
ts1<-ts1p1+ts1p2
ts2<-ts2p1+ts2p2
ts<-c(ts1,ts2)
ra<-rnorm(200,mean=0,sd=0.5)
t.series<-ts+ra
t.series<-t.series-mean(t.series)
times<-c(time1,time2)
res<-wt(t.series, times)
plotmag(res)

#For a wmf object
x1<-0:50
x2<-51:100
x<-c(x1,x2)
ts1<-c(sin(2*pi*x1/10),sin(2*pi*x2/5))+1.1
dat<-matrix(NA,11,length(x))
for (counter in 1:dim(dat)[1])
{
  ts2<-3*sin(2*pi*x/3+2*pi*runif(1))+3.1
  ts3<-rnorm(length(x),0,1.5)
  dat[counter,]<-ts1+ts2+ts3    
  dat[counter,]<-dat[counter,]-mean(dat[counter,])
}
times<-x
res<-wmf(dat,times)
plotmag(res)

#similar calls for wpmf, coh, wlm, wlmtest objects
#see documentation 

}
\references{
Sheppard, L.W., et al. (2016) Changes in large-scale climate alter spatial synchrony of aphid 
pests. Nature Climate Change. DOI: 10.1038/nclimate2881

Sheppard, LW et al. (2019) Synchrony is more than its top-down and climatic parts: interacting 
Moran effects on phytoplankton in British seas. Plos Computational Biology. In press.
}
\seealso{
\code{\link{tts}}, \code{\link{wt}}, \code{\link{wmf}}, \code{\link{wpmf}}, \code{\link{coh}},
\code{\link{wlmtest}}, \code{\link{plotphase}}, \code{\link{bandtest}}, \code{\link{plotrank}},
\code{browseVignettes("wsyn")}
}
\author{
Thomas Anderson, \email{anderstl@gmail.com}, Jon Walter, \email{jaw3es@virginia.edu}; Lawrence 
Sheppard, \email{lwsheppard@ku.edu}; Daniel Reuman, \email{reuman@ku.edu}
}
