% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cleandat.R
\name{cleandat}
\alias{cleandat}
\title{Clean (spatio)temporal data matrices to make them ready for analyses using the \code{wsyn} package}
\usage{
cleandat(dat, times, clev, lambdas = seq(-10, 10, by = 0.01), mints = NA)
}
\arguments{
\item{dat}{A locations x time data matrix, or a time series vector (for 1 location)}

\item{times}{The times of measurement, spacing 1}

\item{clev}{The level of cleaning to do, 1 through 5. See details.}

\item{lambdas}{A vector of lambdas to test for optimal Box-Cox transformation, if Box-Cox is 
performed. Ignored for \code{clev<4}. Defaults to seq(-10,10, by=0.01). See details.}

\item{mints}{If \code{clev} is 4 or 5, then time series are shifted to have this minimum value 
before Box-Cox transformation. Default NA means use the smallest difference between consecutive, 
distinct sorted values. NaN means perform no shift.}
}
\value{
\code{cleandat} returns a list containing the cleaned data, \code{clev}, and the optimal 
lambdas from the Box-Cox procedure (\code{NA} for \code{clev<4}, see details).
}
\description{
A data cleaning function for optimal Box-Cox transformation, detrending, standarizing variance, 
de-meaning
}
\details{
NAs, Infs, etc. in \code{dat} trigger an error. If \code{clev==1}, time series are (individually) 
de-meaned. If \code{clev==2}, time series are (individually) linearly detrended and de-meaned. If \code{clev==3}, 
time series are (individually) linearly detrended and de-meaned, and variances are standardized to 1. If 
\code{clev==4}, an optimal Box-Cox normalization procedure is applied jointly to all time series (so the same
Box-Cox transformation is applied to all time series after they are individually shifted depending on the value
of \code{mints}). Transformed time series are then individually linearly detrended, de-meaned, and variances are
standardized to 1. If \code{clev==5}, an optimal Box-Cox normalization procedure is applied to each time series 
individually (again after individually shifting according to \code{mints}), and transformed time series are then 
individually linearly detrended, de-meaned, and variances are standardized to 1. Constant time series and perfect 
linear trends trigger an error for \code{clev>=3}. If \code{clev>=4} and the optimal \code{lambda} for one or 
more time series is a boundary case or if there is more than one optimal lambda, it triggers a warning. A wider 
range of \code{lambda} should be considered in the former case.
}
\examples{
times<-1:100
dat<-rnorm(100)
res1<-cleandat(dat,times,1) #this removes the mean
res2<-cleandat(dat,times,2) #detrends and removes the mean
res3<-cleandat(dat,times,3) #variances also standardized
res4<-cleandat(dat,times,4) #also joint Box-Cox applied
res5<-cleandat(dat,times,5) #1-3, also indiv Box-Cox

}
\references{
Box, GEP and Cox, DR (1964) An analysis of transformations (with discussion). Journal of the Royal Statistical Society B, 26, 211–252.

Venables, WN and Ripley, BD (2002) Modern Applied Statistics with S. Fourth edition. Springer.

Sheppard, LW, et al. (2016) Changes in large-scale climate alter spatial synchrony of aphid pests. Nature Climate Change. DOI: 10.1038/nclimate2881
}
\seealso{
\code{\link{wt}}, \code{\link{wmf}}, \code{\link{wpmf}}, \code{\link{coh}}, \code{\link{wlm}}, 
\code{\link{wlmtest}}, \code{\link{clust}}, \code{browseVignettes("wsyn")}
}
\author{
Jonathan Walter, \email{jaw3es@virginia.edu}; Lawrence Sheppard, \email{lwsheppard@ku.edu}; 
Daniel Reuman, \email{reuman@ku.edu}; Lei Zhao, \email{lei.zhao@cau.edu.cn}
}
