% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/wtest.snps.meth.R
\name{wtest.snps.meth}
\alias{wtest.snps.meth}
\title{W-test for Gene-methylation Interaction Analysis}
\usage{
wtest.snps.meth(geno, meth, y, geno.pos, meth.pos, window.size = 10000,
  hf = "default.hf", output.pval = NULL, sort = TRUE)
}
\arguments{
\item{geno}{a data frame or matrix containing genotypes in the columns and subjects in the rows. Genotypes should be coded as (0, 1, 2) or (0, 1). SNP names should be stored as column names of the data.}

\item{meth}{a data frame or matrix containing methylation data in the columns. Methylation data should be recoded as (0, 1, 2) or (0, 1). Names of CpG sites should be stored as column names of the data.}

\item{y}{a numeric vector of 0 or 1; or a factor variable with two levels.}

\item{geno.pos}{a data frame containing SNP names and positions in two columns.}

\item{meth.pos}{a data frame containing CpG names and positions in two columns.}

\item{window.size}{a numeric number specifying the size of genome distance. Interaction effects of the SNPs and CpG sites located within the size of genome distance will be evaluated exhaustively.}

\item{hf}{\emph{h} and \emph{f} values to calculate gene-methylation interaction associations, organized as a matrix, with columns (\emph{k}, \emph{h}, \emph{f}), \emph{k} = 2 to 6.}

\item{output.pval}{a p-value threshold for filtering the output. If NULL, all results will be listed; otherwise, the function will only output the results with p-values smaller than \code{output.pval}.}

\item{sort}{a logical value indicating whether or not to sort the output by p-values in ascending order. Default = TRUE.}
}
\value{
An object \code{"wtest.snps.meth"} containing:

\item{results}{The test results include: SNP name, CpG name, SNP position, CpG position, W value, \emph{k}, and p-value.}

\item{hf}{The \emph{h} and \emph{f} values used for each \emph{k} in pairwise calculation, where \emph{k} = 2 to 6.}
}
\description{
{Calculate cis-gene-methylation interaction of a (SNP, CpG) pair in user-defined window, and can run in a genome-wide manner. The output can be filtered by p-values, such that only sets with smaller
p-value than the threshold (\code{output.pval}) will be returned.}
}
\details{
{Calculate cis-gene-methylation interaction of a (SNP, CpG) pair in user-defined window, and can run in a genome-wide manner. The output can be filtered by p-values, such that only sets with smaller
p-value than the threshold (\code{output.pval}) will be returned.}
}
\examples{
data(SNP.pos)
data(CpG.pos)
data(genotype)
data(methylation)
data(phenotype2)

w <- 13000

# Recode methylation data
methylation <- methylation.recode(methylation)

## Step 1. HF Calculation.
# Please note that parameter B is recommended to be greater than 400.
hf.pair <- hf.snps.meth(B = 80, geno = genotype, meth = methylation, y = phenotype2,
                        geno.pos = SNP.pos, meth.pos = CpG.pos, window.size = w)

## Step 2. Application
result <- wtest.snps.meth(geno = genotype, meth = methylation, y = phenotype2, geno.pos = SNP.pos,
                          meth.pos = CpG.pos, window.size = w, hf = hf.pair, output.pval = 0.1)

}
\references{
Maggie Haitian Wang, Rui Sun, Junfeng Guo, Haoyi Weng, Jack Lee, Inchi Hu, Pak Sham and Benny C.Y. Zee (2016). A fast and powerful W-test for pairwise epistasis testing. Nucleic Acids Research. doi:10.1093/nar/gkw347.
}
\seealso{
\code{\link{wtest}}, \code{\link{hf.snps.meth}}
}
\author{
Rui Sun, Maggie Haitian Wang
}
