% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/calcKVA.R
\name{calcKVA}
\alias{calcKVA}
\title{Calculates the Capital Valuation Adjustment (KVA)}
\usage{
calcKVA(exposure_profile, CSA, collateral, trades, reg_data, time_points)
}
\arguments{
\item{exposure_profile}{The exposure profile list containing the EE, EEE etc}

\item{CSA}{The margin agreement with the counterparty}

\item{collateral}{The current amount of collaterals currently exchanged with the counterparty}

\item{trades}{The full list of the Trade Objects}

\item{reg_data}{A list containing data related to the regulatory calculations (for example the 'framework' member variable can be 'IMM','SACCR','CEM')}

\item{time_points}{The timepoints that the analysis is performed on}
}
\value{
The capital valuation adjustment (KVA)
}
\description{
Calculates the capital valuation adjustment by computing the default capital charge and the CVA capital charge and applying the required return-on-capital
}
\author{
Tasos Grivas <tasos@openriskcalculator.com>
}
