% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/calculate-pvalues.R
\name{calc_prob_null_gradient}
\alias{calc_prob_null_gradient}
\title{Gradient of the multinomial likelihood sum}
\usage{
calc_prob_null_gradient(theta_cands, SSpacearr, II)
}
\arguments{
\item{theta_cands}{A matrix with samples in the rows and the parameters in
the columns}

\item{SSpacearr}{A matrix with the sample space for the given size of the
problem}

\item{II}{logical vector of sample space psi being more extreme than the
observed psi}
}
\value{
A matrix the same dimension as theta_cands
}
\description{
Gradient of the multinomial likelihood sum
}
\examples{
calc_prob_null_gradient(t(c(.28, .32, .4)),
matrix(c(2, 2, 1, 1, 2, 2, 0, 3, 2), ncol = 3),
rep(TRUE, 3))

# numerically
testenv <- new.env()
testenv$SSpacearr <- matrix(c(2, 2, 1, 1, 2, 2, 0, 3, 2), ncol = 3)
testenv$thistheta <- c(.28, .32, .4)
numericDeriv(quote(sum(exp((.colSums(t(SSpacearr) * log(thistheta), m = 3, n = 3))))),
    theta = "thistheta", rho = testenv, central = TRUE)


}
