% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Make_cross_v11_Commented.R
\name{xbreed}
\alias{xbreed}
\title{Create crossbred population}
\usage{
xbreed(pop1, pop2, founder_pop1, founder_pop2, founder_cross, Selection_pop1,
  Selection_pop2, Cross_design, ng, litter_size, train_type, train_pop1,
  train_pop2, train_cross, saveAt, output_pop1, output_pop2, output_cross,
  Display)
}
\arguments{
\item{pop1}{(\code{list}) Output of function   \code{\link{make_rp}}, \code{\link{sample_hp}} or \code{\link{xbreed}}.}

\item{pop2}{(\code{list}) Output of function   \code{\link{make_rp}}, \code{\link{sample_hp}} or \code{\link{xbreed}}.}

\item{founder_pop1}{(\code{data.frame}) Data frame with {2} rows and {3} columns. First row is for the selection of male founders and second row is for the selection of female founders from \code{pop1}. The columns are as following:\cr
  Colomn 1) "size" is the number of individuals to be selected. \cr
  Column 2) "generation" is the generation number from which males/females will be selected.\cr
  Column 3) "select" indicates the type of selection with options:
\itemize{
\item{"rnd"}  {Select individuals randomly}.
\item{"phen"}  {Select individuals based on their phenotypes}.
\item{"tbv"}  {Select individuals based on their true breeding value (tbv)}.
\item{"gebv"}  {Select individuals based on their genomic estimated breeding value (gebv)}.
}
  Column 4) "value" Indicates to select high: "h" or low: "l" values. Note: This colomn is ignored if individuals are selected randomly.\cr}

\item{founder_pop2}{(\code{data.frame}) Data frame with {2} rows and {3} columns. First row is for the selection of male founders and second row is for the selection of female founders from \code{pop2}. Details are similar to argument \code{founder_pop1}.}

\item{founder_cross}{(\code{data.frame}) Data frame with {2} rows and {4} columns that contains information about creating base generation of crossbreds.  First row is for the selection of male founders and second row is for the selection of female founders in order to create crossbred population. The columns are as following:\cr
  Column 1) "pop" Indication of the population name from which males/females for crossbreeding will be selected. The two possible options are:
\itemize{
\item{"pop1"}  {Select individuals are from pop1}.
\item{"pop2"}  {Select individuals are from pop2}.
}
  Column 2) "size" is the number of individuals to be selected. \cr
  Column 3) "select" indicates the type of selection with options:
\itemize{
\item{"rnd"}  {Select individuals randomly}.
\item{"phen"}  {Select individuals based on their phenotypes}.
\item{"tbv"}  {Select individuals based on their true breeding value (tbv)}.
\item{"gebv"}  {Select individuals based on their genomic estimated breeding value (gebv)}.
}
  Column 4) "value" Indicates to select high: "h" or low: "l" values. This column is ignored if individuals are selected randomly.\cr
\bold{Note:} After selecting founders for pop1 and pop2, by arguments \code{founder_pop1} and \code{founder_pop2}, user can select individuals from these founders as parents of crossbreds for the base generation of crossbreds. \cr}

\item{Selection_pop1}{(\code{data.frame}) Selection design for pop1 (Breed {1}). Data frame with {2} rows and {3} columns. First row is for the selection design of males and second row is for the selection design of females. The columns are as following:\cr
  Column 1) "Number" is the number of individuals to be selected as sires/dams. \cr
  Column 2) "type" indicates the type of selection with options:
\itemize{
\item{"rnd"}  {Select individuals randomly}.
\item{"phen"}  {Select individuals based on their phenotypes}.
\item{"tbv"}  {Select individuals based on their true breeding value (tbv)}.
\item{"tbvc"}  {Select individuals based on true breeding value for crossbred performance(tbvc)}.
\item{"gebv"}  {Select individuals based on their genomic estimated breeding value (gebv)}.
\item{"gebvc"}  {Select individuals based on genomic estimated breeding value for crossbred performance (gebvc)}.
}
  Column 3) "value" Indicates to select high: "h" or low: "l" values. Note: This colomn is ignored if individuals are selected randomly.\cr}

\item{Selection_pop2}{(\code{data.frame}) Selection design for pop2 (Breed {2}). Details are similar to argument \code{Selection_pop1}.}

\item{Cross_design}{(\code{data.frame}) Data frame containing information on how to select individuals from pop1 and pop2 as parents of crossbreds over generations. This argument is a data frame with {2} rows and {4} columns. First row is for the selection of males as sires of crossbreds and second row is for the selection of females as dams of crossbreds. The columns are as following:\cr
  Column 1) "pop" Indication of the population name from which males/females for crossing will be selected. The two possible options are:
\itemize{
\item{"pop1"}  {Selected individuals are from pop1}. 
\item{"pop2"}  {Selected individuals are from pop2}.
}
As an example if row {1} and column {1} of argument \code{Cross_design} is equal to "pop2", this means that sires of crossbred are from pop2.\cr
  Column 2) "size" is the number of individuals to be selected as sires/dams. \cr
  Column 3) "select" indicates the type of selection with options:
\itemize{
\item{"rnd"}  {Select individuals randomly}.
\item{"phen"}  {Select individuals based on their phenotypes}.
\item{"tbv"}  {Select individuals based on their true breeding value (tbv)}.
\item{"tbvc"}  {Select individuals based on true breeding value for crossbred performance(tbvc)}.
\item{"gebv"}  {Select individuals based on their genomic estimated breeding value (gebv)}.
\item{"gebvc"}  {Select individuals based on genomic estimated breeding value for crossbred performance (gebvc)}.
}
  Column 4) "value" Indicates to select high: "h" or low: "l" values. Note: This column is ignored if individuals are selected randomly.\cr}

\item{ng}{Number of generations. Range: \eqn{1 \leq \code{ng} \leq 200}.}

\item{litter_size}{Litter size or the number of progeny per dam. Range: \eqn{1 \leq \code{x} \leq 200}.}

\item{train_type}{\emph{Optional} (\code{character}) Type of training for the estimation of marker effects. The two possible options are:
\itemize{
\item{"purebred"} {Training will be on purebreds. This means that training for each population is done separately. So, there will be two reference population; one for pop1 (Breed 1) and one for pop2 (Breed 2)}.
\item{"crossbred"} {Training will be on crossbreds. So, estimated marker effects will be the same for both pop1 and pop2}.
}
\bold{Note:} If selection criteria for any population is defined as gebv/gebvc, argument \code{train_type} should be defined.\cr}

\item{train_pop1}{\emph{Optional} (\code{data.frame}) Data frame with {1} row and {8} columns. The columns are as following:\cr
 Column 1) "size" is the number of individuals to be selected for training. \cr
 Column 2) "sel" \emph{Optional} (\code{character}) Indicates the type of the selection of individuals for training. The possible options are:
\itemize{
\item{"rnd"}  {Select individuals for training randomly}.
\item{"min_rel_mrk"}  {Select individuals for training, where genomic relationship among individuals based on marker information is minimum}.
\item{"max_rel_mrk"}  {Select individuals for training, where genomic relationship among individuals based on marker information is maximum}.
\item{"min_rel_qtl"}  {Select individuals for training, where genomic relationship among individuals based on qtl information is minimum}.
\item{"max_rel_qtl"}  {Select individuals for training, where genomic relationship among individuals based on qtl information is maximum}.
}
Default: "rnd" \cr
  Column 3) "method" \emph{Optional} (\code{character}) Method used for the estimation of marker effects. The possible options are:
\itemize{
\item{"BRR"}  {Gaussian prior}.
\item{"BayesA"}  {scaled-t prior}.
\item{"BL"}  {Double-Exponential prior}.
\item{"BayesB"}  {two component mixture prior with a point of mass at zero and a scaled-t slab}.
\item{"BayesC"}  {two component mixture prior with a point of mass at zero and a Gaussian slab}.
}
Default: "BRR" \cr
 Column 4) "nIter" \emph{Optional} The number of iterations. Default: \eqn{1500} \cr
  Column 5) "burnIn" \emph{Optional} The number of burn-in. Default: \eqn{500} \cr
  Column 6) "thin" \emph{Optional} The number of thinning. Default: \eqn{5} \cr
  Column 7) "save" \emph{Optional} This may include a path and a pre-fix that will be added to the name of the files that are saved as the program runs.  Default:"Out_BGLR" \cr 
  Column 8) "show" \emph{Optional} (\code{Logical}) if TRUE the iteration history is printed. Default: \code{TRUE}. \cr
\bold{Note:} This argument is compulsory if argument \code{train_type} is "purbred". \cr
More details about the argument can be found in package \pkg{BGLR}.}

\item{train_pop2}{\emph{Optional} (\code{data.frame}) Data frame with {1} row and {8} columns similar to argument \code{train_pop1}.  \cr
\bold{Note:} This argument is compulsory if argument \code{train_type} is "purbred". \cr}

\item{train_cross}{\emph{Optional} (\code{data.frame}) Data frame with {1} row and {8} columns similar to argument \code{train_pop1}.  \cr
\bold{Note:} This argument is compulsory if argument \code{train_type} is "crossbred".\cr}

\item{saveAt}{\emph{Optional} (\code{character}). Name to be used to save output files.}

\item{output_pop1}{\emph{Optional} (\code{data.frame}). Data frame to specify generation indexs and type of data to be written to output files for "pop1". User can define which type of data and which generations to be written to output files. The possible options are:\cr
\cr
  "data"      Individuals data except their genotypes. \cr
  "qtl"       QTL genotye of individuals coded as {11,12,21,22}. \cr
  "marker"    Marker genotye of individuals. \cr
  "seq"       Genotype (both marker (SNP) and QTL) of individuals.\cr
  "freq_qtl"  QTL allele frequency. \cr
  "freq_mrk"  Marker allele frequency. \cr
\bold{Note:} Both arguments \code{output_pop1} and \code{saveAt} should present in the function in order to write the output files for "pop1".\cr}

\item{output_pop2}{\emph{Optional} (\code{data.frame}). Data frame to specify generations indexs and type of data to be written to output files for pop2. Details are similar to argument \code{output_pop1}.\cr
\bold{Note:} Both arguments \code{output_pop2} and \code{saveAt} should present in the function in order to write the output files for "pop2".\cr}

\item{output_cross}{\emph{Optional} (\code{data.frame}). Data frame to specify generations indexs and type of data to be written to output files for crossbred population. Details are similar to argument \code{output_pop1}.\cr
\bold{Note:} Both arguments \code{output_cross} and \code{saveAt} should present in the function in order to write the output files for crossbred population.}

\item{Display}{\emph{Optional} (\code{Logical}) Display summary of the simulated generations if is not \code{FALSE}. Default: \code{TRUE}.}
}
\value{
\code{list} with all data of simulated populations.\cr
\describe{
\item{$pop1}{(\code{list}) Two-level list  (\code{$pop1[[]][[]]}) containing information about simulated generations. First index (x) indicates generation number. It should be noted that as data for base generation (0) is also stored by the function, to retrive data for a specific generation, index should be equal to generation number plus one. As an example to observe data for generation 2 index should be 3 i.e, \code{$pop1[[3]]$data}. Second index (y) that ranges from {1} to {6} contain the information as following: 
\itemize{
\item{\code{$pop1[[x]]$data}}  {Individuals data except their genotypes. Here x is the generation index}.
\item{\code{$pop1[[x]]$qtl}}  {QTL genotye of individuals}.
\item{\code{$pop1[[x]]$mrk}}   {Marker genotye of individuals}.
\item{\code{$pop1[[x]]$sequ}}  {Genotype (both marker (SNP) and QTL) of individuals}.
\item{\code{$pop1[[x]]$freqQTL}}   {QTL allele frequency}.
\item{\code{$pop1[[x]]$freqMRK}}   {Marker allele frequency}.
}
}
\item{$pop2}{Similar to $pop1}
\item{$cross}{(\code{list}) Two-level list (\code{$cross$output[[x]][[y]]}) containing information about simulated crossbred generations. Details are similar to \code{$pop1} such as:	
\itemize{
\item{\code{$cross$output[[x]]$data}}  {Crossbred individuals data except their genotypes. Here x is the generation index}.
\item{\code{$cross$output[[x]]$qtl}}  {QTL genotye of crossbred individuals}.
\item{\code{$cross$output[[x]]$mrk}}  {Marker genotye of individuals}.
\item{\code{$cross$output[[x]]$sequ}}  {Genotype (both marker (SNP) and QTL) of individuals}.
\item{\code{$cross$output[[x]]$freqQTL}}  {QTL allele frequency}.
\item{\code{$cross$output[[x]]$freqMRK}}  {Marker allele frequency}.
}
}
\item{$cross$summary_data_cross}{Data frame with summary of simulated crossbreds}. 	
\item{$summary_data_pop1}{Data frame with summary of simulated generations for pop1 (Breed 1)}. 
\item{$summary_data_pop2}{Data frame with summary of simulated generations for pop2 (Breed 2)}. 
\item{$linkage_map_qtl}{Linkage map for qtl}.  
\item{$linkage_map_mrk}{Linkage map for marker}.
\item{$linkage_map_qtl_mrk}{Integrated linkage map for both marker and qtl}.
\item{$allele_effcts}{QTL allele effects}.
\item{$trait}{Trait specifications}.
\item{$genome}{Genome specifications}.
}
}
\description{
This function can be used for crossing between populations. Different crossbreeding schemes such as two-way, three-way and four-way crossbreeding schemes can be simulated.
}
\details{
Function \code{xbreed} is used for crossing between populations. These populations can be the ones created by functions \code{sample_hp} and \code{make_rp}. Also, if user would like to have multi-way crossbreeding schemes such as three-way crossbreeding, then function \code{xbreed} can be used to get the output of itself as input data in order to create the multi-way crossbreed populations. Simulations of two-way and multi-way crossbreeding schemes are presented in the package vignette.
}
\examples{
\dontrun{
# # Simulation of a two-way crossbreeding program.
# The crossbreeding scheme in this example involves three steps:    
#Step 1: Historical population is created.      
#Step 2: Two recent populations named as Breed A and B
# are created by sampling individuals from historical population.       
#Step 3: Breed A and B are crossed.  

#--------------------------------------
# # STEP 1: CREATE HISTORICAL POPULATION

# Genome consisted of 3 chromosomes
genome<-data.frame(matrix(NA, nrow=3, ncol=6))
names(genome)<-c("chr","len","nmrk","mpos","nqtl","qpos")
genome$chr<-c(1:3)
genome$len<-rep(100,3)	
genome$nmrk<-rep(100,3)
genome$mpos<-rep('rnd',3)	
genome$nqtl<-rep(25,3)
genome$qpos<-rep('rnd',3)	
genome

historical<-make_hp(hpsize=300
,ng=10,h2=0.25,d2=0.10,phen_var=1
,genome=genome,mutr=5*10**-4,laf=0.5)

# # STEP 2: MAKE BREED A AND B 
# BREED A
Breed_A_Male_fndrs<-data.frame(number=50,select='rnd') 
Breed_A_Female_fndrs<-data.frame(number=50,select='rnd') 

# Selection and matings in Breed A
	# Selection of 50 sires and 50 dam			
	# Selection criteria is "rnd" for both sires and dams
 Selection<-data.frame(matrix(NA, nrow=2, ncol=2))
 names(Selection)<-c("Number","type")
 Selection$Number[1:2]<-c(50,50)	
 Selection$type[1:2]<-c("rnd","rnd")	
 Selection

Breed_A<-sample_hp(hp_out=historical,Male_founders=
Breed_A_Male_fndrs,Female_founders=Breed_A_Female_fndrs,
ng=5,Selection=Selection,
litter_size=3,Display=TRUE)
 
# BREED B
Breed_B_Male_fndrs<-data.frame(number=50,select="rnd") 
Breed_B_Female_fndrs<-data.frame(number=50,select="rnd") 

# Selection and matings in Breed B
	# Selection of 50 sires and 50 dam			
	# Selection criteria is "phen" for both sires and dams

Selection<-data.frame(matrix(NA, nrow=2, ncol=3))
names(Selection)<-c("Number","type","Value")
Selection$Number[1:2]<-c(50,50)	
Selection$type[1:2]<-c("phen","phen")	
Selection$Value[1:2]<-c("h","h") 
Selection

Breed_B<-sample_hp(hp_out=historical,Male_founders=
Breed_B_Male_fndrs,Female_founders=Breed_B_Female_fndrs,
ng=5,Selection=Selection,
litter_size=3,Display=TRUE)

# # STEP 3: CROSSING BETWEEN BREED A AND B

  # Selection of founders in crossbreeding for Breed A 
		# Selection of 50 sires and 50 dams 
         # from last generation of pop in step 2. 			
	# Selection criteria is "rnd" for both sires and dams
founder_pop1<-data.frame(matrix(NA, nrow=2, ncol=3))
names(founder_pop1)<-c("size","generation","select")
founder_pop1[1,]<-c(50,5,"rnd") 
founder_pop1[2,]<-c(50,5,"rnd")
founder_pop1
  
# Selection of founders in crossbreeding for Breed B 
	# Selection of 40 sires and 40 dams			
	# Selection criteria is "phen" for sires 
	# Selection criteria is "rnd" for dams

founder_pop2<-data.frame(matrix(NA, nrow=2, ncol=4))
names(founder_pop2)<-c("size","generation","select","value")
founder_pop2[1,]<-c(40,5,"phen","h") 
founder_pop2[2,]<-c(40,5,"rnd","h") # "h" will be ignored as SC is "rnd"
founder_pop2

# Selection of animals from founder_pop1 and founder_pop2 to be crossed
founder_cross<-data.frame(matrix(NA, nrow=2, ncol=4))
names(founder_cross)<-c("pop","size","select","value")
founder_cross[1,]<-c("pop1",35,"tbv","h") # Select males from Breed A
founder_cross[2,]<-c("pop2",40,"phen","h")  # Select females from Breed B
founder_cross

# Selection scheme in Breed A to produce purebred replacement animals 
Selection_pop1<-data.frame(matrix(NA, nrow=2, ncol=3))
names(Selection_pop1)<-c("Number","type","Value")
Selection_pop1$Number[1:2]<-c(70,70)				
Selection_pop1$type[1:2]<-c("tbv","tbv")	
Selection_pop1$Value[1:2]<-c("h","h")
Selection_pop1

# Selection scheme in Breed B to produce purebred replacement animals 
Selection_pop2<-data.frame(matrix(NA, nrow=2, ncol=3))
names(Selection_pop2)<-c("Number","type","Value")
Selection_pop2$Number[1:2]<-c(40,40)				
Selection_pop2$type[1:2]<-c("phen","phen")	
Selection_pop2$Value[1:2]<-c("h","h")
Selection_pop2

# Selection scheme for crossing between A and B
Cross_design<-data.frame(matrix(NA, nrow=2, ncol=4))
names(Cross_design)<-c("pop","size","select","value")
Cross_design[1,]<-c("pop1",50,"phen","h") 
Cross_design[2,]<-c("pop2",100,"phen","h")
Cross_design

# Save data for crossbred AB
output_cross<-data.frame(matrix(NA, nrow=1, ncol=1))
output_cross[,1]<-c(1)
output_cross

cross_AB<-xbreed(pop1=Breed_A,pop2=Breed_B,founder_pop1=
founder_pop1,founder_pop2=founder_pop2,
founder_cross=founder_cross,
Selection_pop1=Selection_pop1,Selection_pop2=Selection_pop2,
Cross_design=Cross_design,ng=2,litter_size=4,
saveAt="cross_pop",output_cross=output_cross,Display=TRUE)
}
}
\references{
{Esfandyari H., A.C Sorensen and P. Bijma. 2015. A crossbred reference population can improve the response to genomic selection for crossbred performance. \emph{Genetics Selection Evolution} \bold{47}: 76}

{Esfandyari H., A.C Sorensen and P. Bijma. 2015. Maximizing crossbred performance through purebred genomic selection. \emph{Genetics Selection Evolution} \bold{47}: 16}
}
\seealso{
\code{\link{make_rp}}, \code{\link{sample_hp}}
}
