% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/xegaNextPopulation.R
\name{xegaNextPopulation}
\alias{xegaNextPopulation}
\title{Computes the next population of genes.}
\usage{
xegaNextPopulation(pop, fit, lF)
}
\arguments{
\item{pop}{Population of genes.}

\item{fit}{Fitness.}

\item{lF}{Local configuration.}
}
\value{
Population of genes.
}
\description{
\code{xegaNextPopulation()} 
             builds the next population by repeatedly
             calling \code{ReplicateGene()}.
}
\details{
The current version is sequential.
         For parallelization, a restructuring of the 
         main loop with an integration of \code{xegaNextPopulation}
         and \code{xegaEvalPopulation} is planned, because
         this allows the parallelization of a large part of 
         the genetic operations which are sequential in the 
         current version.
}
\examples{
lFxegaGaGene$MutationRate<-MutationRateFactory(method="Const")
lFxegaGaGene$ReplicateGene<-ReplicateGene
lFxegaGaGene$Accept<-AcceptFactory(method="All")
pop10<-xegaInitPopulation(10, lFxegaGaGene)
epop10<-xegaEvalPopulation(pop10, lFxegaGaGene)
newpop<-xegaNextPopulation(epop10$pop, epop10$fit, lFxegaGaGene)

}
\seealso{
Other Population Layer: 
\code{\link{xegaBestGeneInPopulation}()},
\code{\link{xegaBestInPopulation}()},
\code{\link{xegaEvalPopulation}()},
\code{\link{xegaInitPopulation}()},
\code{\link{xegaLogEvalsPopulation}()},
\code{\link{xegaObservePopulation}()},
\code{\link{xegaRepEvalPopulation}()},
\code{\link{xegaSummaryPopulation}()}
}
\concept{Population Layer}
