% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/selectGene.R
\name{SelectPropFitDiffM}
\alias{SelectPropFitDiffM}
\title{Selection proportional to fitness differences.}
\usage{
SelectPropFitDiffM(fit, lF, size = 1)
}
\arguments{
\item{fit}{Fitness vector.}

\item{lF}{Local configuration.}

\item{size}{Number of selected genes. Default: 1.}
}
\value{
The index vector of the selected genes.
}
\description{
\code{SelectPropFitDiffM} implements selection
             proportional to fitness differences.
             It selects a gene from the population
             with a probability proportional to the fitness
             difference to the gene with minimal fitness.
             The fitness of survival of the gene with 
             minimal fitness is set by \code{lF$Eps()} 
             to \code{0.01} per default.
             See equation (7.45) Andreas Geyer-Schulz (1997), p. 205.
}
\section{Warning}{

             \code{outer} uses \eqn{O(n^2)} memory cells.
}

\section{Note}{
 
       \code{SelectPopFitDiff} is a dynamic scaling function.
}

\examples{
fit<-sample(10, 15, replace=TRUE)
SelectPropFitDiffM(fit, NewlFselectGenes()) 
SelectPropFitDiffM(fit, NewlFselectGenes(), length(fit)) 
}
\references{
Andreas Geyer-Schulz (1997):
         \emph{Fuzzy Rule-Based Expert Systems and Genetic Machine Learning},
               Physica, Heidelberg.
          <978-3-7908-0830-X>
}
\seealso{
Other Selection Functions: 
\code{\link{SelectDuel}()},
\code{\link{SelectLRSelective}()},
\code{\link{SelectLinearRankTSR}()},
\code{\link{SelectPropFitDiffOnln}()},
\code{\link{SelectPropFitDiff}()},
\code{\link{SelectPropFitM}()},
\code{\link{SelectPropFitOnln}()},
\code{\link{SelectPropFit}()},
\code{\link{SelectSTournament}()},
\code{\link{SelectSUS}()},
\code{\link{SelectTournament}()},
\code{\link{SelectUniformP}()},
\code{\link{SelectUniform}()}
}
\concept{Selection Functions}
