% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/selectGene.R
\name{SelectPropFitDiffOnln}
\alias{SelectPropFitDiffOnln}
\title{Selection proportional to fitness differences O(n ln(n)).}
\usage{
SelectPropFitDiffOnln(fit, lF, size = 1)
}
\arguments{
\item{fit}{Fitness vector.}

\item{lF}{Local configuration.}

\item{size}{Number of selected genes. Default: 1.}
}
\value{
The index vector of the selected genes.
}
\description{
\code{SelectPropFitDiffOnln} implements selection
             proportional to fitness differences. Negative fitness
             vectors are shifted to \eqn{R^+}.
             The default of the function \code{lf$Offset} is \code{1}. 
             Holland's schema theorem uses this selection function.
             See John Holland (1975) for further information.
}
\details{
This is a fast implementation which gives exactly the same 
          results as the functions \code{SelectPropFitDiff} 
          and \code{SelectPropDiffFitM}.
          Its runtime is \eqn{O(n . ln(n))}.
}
\section{Credits}{

         The code of this function has been adapted by 
         Fabian Aisenbrey.
}

\section{Warning}{

             There is a potential slow for-loop in the code.
}

\examples{
fit<-sample(10, 15, replace=TRUE)
SelectPropFitDiffOnln(fit, NewlFselectGenes()) 
SelectPropFitOnln(fit, NewlFselectGenes(), length(fit)) 
}
\references{
Holland, John (1975): 
             \emph{Adaptation in Natural and Artificial Systems},  
             The University of Michigan Press, Ann Arbor.
             (ISBN:0-472-08460-7)
}
\seealso{
Other Selection Functions: 
\code{\link{SelectDuel}()},
\code{\link{SelectLRSelective}()},
\code{\link{SelectLinearRankTSR}()},
\code{\link{SelectPropFitDiffM}()},
\code{\link{SelectPropFitDiff}()},
\code{\link{SelectPropFitM}()},
\code{\link{SelectPropFitOnln}()},
\code{\link{SelectPropFit}()},
\code{\link{SelectSTournament}()},
\code{\link{SelectSUS}()},
\code{\link{SelectTournament}()},
\code{\link{SelectUniformP}()},
\code{\link{SelectUniform}()}
}
\concept{Selection Functions}
