% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/selectGene.R
\name{SelectTournament}
\alias{SelectTournament}
\title{Tournament selection.}
\usage{
SelectTournament(fit, lF, size = 1)
}
\arguments{
\item{fit}{Fitness vector.}

\item{lF}{Local configuration.}

\item{size}{Number of selected genes. Default: \code{1}.}
}
\value{
The index vector of the selected genes.
}
\description{
\code{SelectTournament} implements selection
             by doing a tournament between \code{lF$TournamentSize()} 
             randomly selected genes. The best gene always wins.
             The default of \code{lF$TournamentSize()} is \code{2}. This 
             is the version with the least selection pressure.
             
             \code{lF$TournamentSize} must be less than the population size.
}
\examples{
fit<-sample(10, 15, replace=TRUE)
SelectTournament(fit, NewlFselectGenes()) 
SelectTournament(fit, NewlFselectGenes(), length(fit)) 
}
\seealso{
Other Selection Functions: 
\code{\link{SelectDuel}()},
\code{\link{SelectLRSelective}()},
\code{\link{SelectLinearRankTSR}()},
\code{\link{SelectPropFitDiffM}()},
\code{\link{SelectPropFitDiffOnln}()},
\code{\link{SelectPropFitDiff}()},
\code{\link{SelectPropFitM}()},
\code{\link{SelectPropFitOnln}()},
\code{\link{SelectPropFit}()},
\code{\link{SelectSTournament}()},
\code{\link{SelectSUS}()},
\code{\link{SelectUniformP}()},
\code{\link{SelectUniform}()}
}
\concept{Selection Functions}
