% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/string.R
\name{valid_syntax}
\alias{valid_syntax}
\title{Check if the syntax of the code is valid}
\usage{
valid_syntax(code, silent = TRUE)
}
\arguments{
\item{code}{A character vector of R source code.}

\item{silent}{Whether to suppress the error message when the code is not
valid.}
}
\value{
\code{TRUE} if the code could be parsed, otherwise \code{FALSE}.
}
\description{
Try to \code{\link{parse}()} the code and see if an error occurs.
}
\examples{
xfun::valid_syntax("1+1")
xfun::valid_syntax("1+")
xfun::valid_syntax(c("if(T){1+1}", "else {2+2}"), silent = FALSE)
}
