% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utils.R
\name{retry}
\alias{retry}
\title{Retry calling a function for a number of times}
\usage{
retry(fun, ..., .times = 3, .pause = 5)
}
\arguments{
\item{fun}{A function.}

\item{...}{Arguments to be passed to the function.}

\item{.times}{The number of times.}

\item{.pause}{The number of seconds to wait before the next attempt.}
}
\description{
If the function returns an error, retry it for the specified number of
times, with a pause between attempts.
}
\details{
One application of this function is to download a web resource. Since the
download might fail sometimes, you may want to retry it for a few more times.
}
\examples{
\dontshow{if (interactive()) (if (getRversion() >= "3.4") withAutoprint else force)(\{ # examplesIf}
# read the Github releases info of the repo yihui/xfun
xfun::retry(xfun::github_releases, "yihui/xfun")
\dontshow{\}) # examplesIf}
}
