% Generated by roxygen2 (4.0.1): do not edit by hand
\docType{methods}
\name{predict,xgb.Booster-method}
\alias{predict,xgb.Booster-method}
\title{Predict method for eXtreme Gradient Boosting model}
\usage{
\S4method{predict}{xgb.Booster}(object, newdata, outputmargin = FALSE)
}
\arguments{
\item{object}{Object of class "xgb.Boost"}

\item{newdata}{takes \code{matrix}, \code{dgCMatrix}, local data file or
\code{xgb.DMatrix}.}

\item{outputmargin}{whether the prediction should be shown in the original
  value of sum of functions, when outputmargin=TRUE, the prediction is
  untransformed margin value. In logistic regression, outputmargin=T will
  output value before logistic transformation.}
}
\description{
Predicted values based on xgboost model object.
}
\examples{
data(iris)
bst <- xgboost(as.matrix(iris[,1:4]),as.numeric(iris[,5]), nrounds = 2)
pred <- predict(bst, as.matrix(iris[,1:4]))
}

