% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot.bsplines.R
\name{plot.bsplines}
\alias{plot.bsplines}
\title{plot.bsplines}
\usage{
\method{plot}{bsplines}(
  x,
  cov,
  conf.int = TRUE,
  baseline = FALSE,
  xrange,
  yrange,
  xlegend,
  ylegend,
  glegend,
  xaxs = NULL,
  add = FALSE,
  col = 1,
  lty = 1,
  lwd = 1,
  ...
)
}
\arguments{
\item{x}{An object of class xhaz}

\item{cov}{specify covariates for which a plot is required.}

\item{conf.int}{a vector of logical values indicating whether (if TRUE)
confidence intervals will be plotted. The default is to do so if the plot
concerns only one curve.}

\item{baseline}{a vector of logical values indicating whether (if \code{baseline = TRUE})
to plot the curve for the baseline group. Default is FALSE, except if cov
is unspecified.}

\item{xrange}{vector indicating the minimum and the maximum values of the
x axis. By default, these values are automatically calculated for the first
plot (i.e before the use of add argument).}

\item{yrange}{vector indicating the minimum and the maximum values of the y
axis. By default, these values are automatically calculated for the
first plot (i.e before the use of add argument).}

\item{xlegend}{value indicating the location of the legend over x axis.
By default, location at the left of the plot.}

\item{ylegend}{value indicating the location of the legend over y axis.
By default, location at the top of the plot}

\item{glegend}{vectors of names attributed to each lines of the excess hazard
to be displayed in the plot. If (\code{baseline = TRUE}), glegend is \code{"baseline"}.}

\item{xaxs}{the x axis style, as listed in 'par'. Survival curves are
traditionally drawn with the curve touching the bounding box on the left
edge, but not touching it on the right edge. This corresponds to neither
of the two standard S axis styles of "e" (neither touches) or "i" (both touch).
If xaxis is missing or NULL the internal axis style is used (xaxs= i) but
only after the right endpoint has been extended.}

\item{add}{a logical value indicating whether to add the survival curves to the
current plot (if \code{add = TRUE}). Default is FALSE.}

\item{col}{a vector of integers specifying colors for each curve. The default
value is 1.}

\item{lty}{a vector of integers specifying line types for each curve. The
default value is fixed by the number of covariates (plus 1 if \code{baseline = TRUE}).}

\item{lwd}{a vector of numeric values for line widths. The default value is 1.}

\item{...}{additional arguments affecting the plot function}
}
\value{
The return of this function produce graphics of log hazard ratio
functions for non-proportional hazards model
}
\description{
to plot the log hazard ratio functions for non-proportional
hazards model
}
\examples{
\donttest{
# load the data set in the package
library("xhaz")
library("survexp.fr")

data("dataCancer", package = "xhaz")   # load the data set in the package

fit.nphBS <- xhaz(
      formula = Surv(obs_time_year, event) ~ ageCentre + qbs(immuno_trt),
      data = dataCancer,
      ratetable = survexp.fr,
      interval = c(0, NA, NA, max(dataCancer$obs_time_year)),
      rmap = list(age = 'age', sex = 'sexx', year = 'year_date'),
      baseline = "bsplines", pophaz  = "classic")

 plot(fit.nphBS, cov = "immuno_trt", col = "blue", baseline = FALSE)
}
}
\references{
Goungounga JA, Touraine C, Grafféo N, Giorgi R;
CENSUR working survival group. Correcting for misclassification
and selection effects in estimating net survival in clinical trials.
BMC Med Res Methodol. 2019 May 16;19(1):104.
doi: 10.1186/s12874-019-0747-3. PMID: 31096911; PMCID: PMC6524224.
(\href{https://pubmed.ncbi.nlm.nih.gov/31096911/}{PubMed})

Touraine C, Grafféo N, Giorgi R; CENSUR working survival group.
More accurate cancer-related excess mortality through correcting
background mortality for extra variables.
Stat Methods Med Res. 2020 Jan;29(1):122-136.
doi: 10.1177/0962280218823234. Epub 2019 Jan 23. PMID: 30674229.
(\href{https://pubmed.ncbi.nlm.nih.gov/30674229/}{PubMed})

Mba RD, Goungounga JA, Grafféo N, Giorgi R; CENSUR working survival group.
Correcting inaccurate background mortality in excess hazard models
through breakpoints. BMC Med Res Methodol. 2020 Oct 29;20(1):268.
doi: 10.1186/s12874-020-01139-z. PMID: 33121436; PMCID: PMC7596976.
(\href{https://pubmed.ncbi.nlm.nih.gov/33121436/}{PubMed})

Giorgi R, Abrahamowicz M, Quantin C, Bolard P, Esteve J, Gouvernet J,
Faivre J. A relative survival regression model using B-spline functions
to model non-proportional hazards.
Statistics in Medicine 2003; 22: 2767-84.
(\href{https://pubmed.ncbi.nlm.nih.gov/12939785/}{PubMed})
}
\author{
Juste Goungounga, Robert Darlin Mba, Nathalie Grafféo and Roch Giorgi
}
\keyword{plot.bsplines}
