% Generated by roxygen2 (4.1.0): do not edit by hand
% Please edit documentation in R/xml_parse.R
\name{read_xml}
\alias{read_html}
\alias{read_xml}
\alias{read_xml.character}
\alias{read_xml.connection}
\alias{read_xml.raw}
\title{Read HTML or XML.}
\usage{
read_xml(x, encoding = "", ..., as_html = FALSE)

read_html(x, encoding = "", ...)

\method{read_xml}{character}(x, encoding = "", ..., as_html = FALSE)

\method{read_xml}{raw}(x, encoding = "", base_url = "", ...,
  as_html = FALSE)

\method{read_xml}{connection}(x, encoding = "", n = 64 * 1024,
  verbose = FALSE, ..., base_url = "", as_html = FALSE)
}
\arguments{
\item{x}{A string, a connection, or a raw vector.

  A string can be either a path, a url or literal xml. Urls will
  be converted into connections either using \code{base::url} or, if
  installed, \code{curl::curl}. Local paths ending in \code{.gz},
  \code{.bz2}, \code{.xz}, \code{.zip} will be automatically uncompressed.

  If a connection, the complete connection is read into a raw vector before
  being parsed.}

\item{encoding}{Specify a default encoding for the document. Unless
otherwise specified XML documents are assumed to be in UTF-8 or
UTF-16. If the document is not UTF-8/16, and lacks an explicit
encoding directive, this allows you to supply a default.}

\item{...}{Additional arguments passed on to methods.}

\item{as_html}{Optionally parse an xml file as if it's html.}

\item{base_url}{When loading from a connection, raw vector or literal
html/xml, this allows you to specify a base url for the document. Base
urls are used to turn relative urls into absolute urls.}

\item{n}{If \code{file} is a connection, the number of bytes to read per
iteration. Defaults to 64kb.}

\item{verbose}{When reading from a slow connection, this prints some
output on every iteration so you know its working.}
}
\value{
An XML document. HTML is normalised to valid XML - this may not
  be exactly the same transformation performed by the browser, but it's
  a reasonable approximation.
}
\description{
Read HTML or XML.
}
\examples{
# Literal xml/html is useful for small examples
read_xml("<foo><bar /></foo>")
read_html("<html><title>Hi<title></html>")
read_html("<html><title>Hi")

# From a local path
read_html(system.file("extdata", "r-project.html", package = "xml2"))

# From a url
cd <- read_xml("http://www.xmlfiles.com/examples/cd_catalog.xml")
me <- read_html("http://had.co.nz")
}

