% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/all_generics.R, R/Class_permtest.R,
%   R/permtest.R
\name{permtest}
\alias{permtest}
\alias{print.permtest}
\alias{permtest,tskrrHeterogeneous-method}
\alias{permtest,tskrrHomogeneous-method}
\alias{permtest,tskrrTune-method}
\title{Calculate the relative importance of the edges}
\usage{
permtest(x, ...)

\method{print}{permtest}(x, digits = max(3L, getOption("digits") - 3), ...)

\S4method{permtest}{tskrrHeterogeneous}(
  x,
  n = 100,
  permutation = c("both", "row", "column"),
  exclusion = c("interaction", "row", "column", "both"),
  replaceby0 = FALSE,
  fun = loss_mse,
  exact = FALSE
)

\S4method{permtest}{tskrrHomogeneous}(
  x,
  n = 100,
  permutation = c("both"),
  exclusion = c("interaction", "both"),
  replaceby0 = FALSE,
  fun = loss_mse,
  exact = FALSE
)

\S4method{permtest}{tskrrTune}(x, permutation = c("both", "row", "column"), n = 100)
}
\arguments{
\item{x}{either a \code{\link{tskrr-class}} or a
\code{\link{tskrrTune-class}} object}

\item{...}{arguments passed to other methods}

\item{digits}{the number of digits shown in the output}

\item{n}{the number of permutations for every kernel matrix}

\item{permutation}{a character string that defines whether the row,
column or both kernel matrices should be permuted. Ignored in case of
a homogeneous network}

\item{exclusion}{the exclusion to be used in the \code{\link{loo}} function. See also \code{\link{get_loo_fun}}}

\item{replaceby0}{a logical value indicating whether \code{\link{loo}}
removes a value in the leave-one-out procedure or replaces it by zero.
See also \code{\link{get_loo_fun}}.}

\item{fun}{a function (or a character string with the name of a
function) that calculates the loss. See also \code{\link{tune}} and
\code{\link{loss_functions}}}

\item{exact}{a logical value that indicates whether or not an
exact p-value should be calculated, or be approximated based on
a normal distribution.}
}
\value{
An object of the class permtest.
}
\description{
This function does a permutation-based evaluation of the impact of
different edges on the final result. It does so by permuting the kernel
matrices, refitting the model and calculating a loss function.
}
\details{
The test involved uses a normal approximation. It assumes that under the
null hypothesis, the loss values are approximately normally distributed.
The cumulative probability of a loss as small or smaller than
the one found in the original model, is calculated based on a normal
distribution from which the mean and sd are calculated from the permutations.
}
\section{Warning}{
 It should be noted that this normal approximation is an ad-hoc approach.
There's no guarantee that the actual distribution of the loss under the
null hypothesis is normal. Depending on the loss function, a significant
deviation from the theoretic distribution can exist. Hence this functions should only
be used as a rough guidance in model evaluation.
}

\examples{

# Heterogeneous network

data(drugtarget)

mod <- tskrr(drugTargetInteraction, targetSim, drugSim)
permtest(mod, fun = loss_auc)

}
