library(xpectr)
context("gxs_function()")

test_that("gxs_function() works", {



  # Some arbitrary function
  # Have constraints on the arguments
  # and will output slightly different things depending on
  # the values of the args
  fn <- function(a, a_fn, b, d = NULL, e = 3, f = "hi"){

    # Check arguments ####
    assert_collection <- checkmate::makeAssertCollection()
    checkmate::assert_number(x = a, lower = 4, upper = 6, add = assert_collection)
    checkmate::assert_function(x = a_fn, add = assert_collection)
    checkmate::assert_character(x = b, min.chars = 3,
                                any.missing = FALSE,
                                len = 2,
                                add = assert_collection)
    checkmate::assert_data_frame(
      x = d,
      min.rows = 3,
      min.cols = 1,
      col.names = "named",
      null.ok = TRUE,
      add = assert_collection
    )
    checkmate::assert_count(
      x = e,
      positive = TRUE,
      null.ok = TRUE,
      add = assert_collection
    )
    checkmate::assert_string(x = f, min.chars = 2, add = assert_collection)
    checkmate::reportAssertions(assert_collection)
    # End of argument checks ####

    n <- a_fn(a * e)
    m <- paste0(f, ": ", paste0(b, collapse = ", "))

    if (!is.null(d)){
      d[["column"]] <- n
      output <- list("d" = d, "m" = m)
    } else {
      output <- list("n" = n, "m" = m)
    }

    output
  }

  current_envir <- sys.frame(which = sys.nframe())

  set_test_seed(1)
  # All errors ####
  expected_tests <- c(
    " ",
    "## Testing 'fn'                                                             ####",
    "## Initially generated by xpectr",
    "# Testing different combinations of argument values",
    " ",
    "# Testing fn(a = 1, a_fn = mean, b = \"ah\")",
    "xpectr::set_test_seed(42)",
    "# Testing side effects",
    "expect_error(\n  xpectr::strip_msg(fn(a = 1, a_fn = mean, b = \"ah\")),\n  xpectr::strip(paste0(\"2 assertions failed:\\n * Variable 'a': Element 1 is not >= \",\n                       \"4.\\n * Variable 'b': Must have length 2, but has length 1.\")),\n  fixed = TRUE)",
    " ",
    "# Testing fn(a = 2, a_fn = mean, b = \"ah\")",
    "# Changed from baseline: a",
    "xpectr::set_test_seed(42)",
    "# Testing side effects",
    "expect_error(\n  xpectr::strip_msg(fn(a = 2, a_fn = mean, b = \"ah\")),\n  xpectr::strip(paste0(\"2 assertions failed:\\n * Variable 'a': Element 1 is not >= \",\n                       \"4.\\n * Variable 'b': Must have length 2, but has length 1.\")),\n  fixed = TRUE)",
    " ",
    "# Testing fn(a = NULL, a_fn = mean, b = \"ah\")",
    "# Changed from baseline: a",
    "xpectr::set_test_seed(42)",
    "# Testing side effects",
    "expect_error(\n  xpectr::strip_msg(fn(a = NULL, a_fn = mean, b = \"ah\")),\n  xpectr::strip(paste0(\"2 assertions failed:\\n * Variable 'a': Must be of type 'num\",\n                       \"ber', not 'NULL'.\\n * Variable 'b': Must have length 2, but \",\n                       \"has length 1.\")),\n  fixed = TRUE)",
    " ",
    "# Testing fn(a = 1, a_fn = sum, b = \"ah\")",
    "# Changed from baseline: a_fn",
    "xpectr::set_test_seed(42)",
    "# Testing side effects",
    "expect_error(\n  xpectr::strip_msg(fn(a = 1, a_fn = sum, b = \"ah\")),\n  xpectr::strip(paste0(\"2 assertions failed:\\n * Variable 'a': Element 1 is not >= \",\n                       \"4.\\n * Variable 'b': Must have length 2, but has length 1.\")),\n  fixed = TRUE)",
    " ",
    "# Testing fn(a = 1, a_fn = NULL, b = \"ah\")",
    "# Changed from baseline: a_fn",
    "xpectr::set_test_seed(42)",
    "# Testing side effects",
    "expect_error(\n  xpectr::strip_msg(fn(a = 1, a_fn = NULL, b = \"ah\")),\n  xpectr::strip(paste0(\"3 assertions failed:\\n * Variable 'a': Element 1 is not >= \",\n                       \"4.\\n * Variable 'a_fn': Must be a function, not 'NULL'.\\n * \",\n                       \"Variable 'b': Must have length 2, but has length 1.\")),\n  fixed = TRUE)",
    " ",
    "# Testing fn(a = 1, a_fn = mean, b = \"eh\")",
    "# Changed from baseline: b",
    "xpectr::set_test_seed(42)",
    "# Testing side effects",
    "expect_error(\n  xpectr::strip_msg(fn(a = 1, a_fn = mean, b = \"eh\")),\n  xpectr::strip(paste0(\"2 assertions failed:\\n * Variable 'a': Element 1 is not >= \",\n                       \"4.\\n * Variable 'b': Must have length 2, but has length 1.\")),\n  fixed = TRUE)",
    " ",
    "# Testing fn(a = 1, a_fn = mean, b = NULL)",
    "# Changed from baseline: b",
    "xpectr::set_test_seed(42)",
    "# Testing side effects",
    "expect_error(\n  xpectr::strip_msg(fn(a = 1, a_fn = mean, b = NULL)),\n  xpectr::strip(paste0(\"2 assertions failed:\\n * Variable 'a': Element 1 is not >= \",\n                       \"4.\\n * Variable 'b': Must be of type 'character', not 'NULL'\",\n                       \".\")),\n  fixed = TRUE)",
    " ",
    "## Finished testing 'fn'                                                    ####",
    " "
  )

  expect_equal(
    strip(gxs_function(fn, list(
        "a" = list(1, 2),
        a_fn = list(mean, sum),
        "b" = list("ah", "eh")
      ),
      out = "return")),
    strip(expected_tests),
    fixed = TRUE)
  expect_equal(
  length( gxs_function(fn, list(
        "a" = list(1, 2),
        a_fn = list(mean, sum),
        "b" = list("ah", "eh")
      ),
      out = "return") ),
  48L)

  eval_expectations(expected_tests, envir = current_envir)


  # Good baseline values  ####

  # Set seed as assignment names are random
  set_test_seed(1)

  expected_tests2 <- c(
    " ",
    "## Testing 'fn'                                                             ####",
    "## Initially generated by xpectr",
    "# Testing different combinations of argument values",
    " ",
    "# Testing fn(a = 5, a_fn = mean, b = c(\"ahhh\", \"ohhh\"), ...",
    "xpectr::set_test_seed(42)",
    "# Assigning output",
    "output_12655 <- fn(a = 5, a_fn = mean, b = c(\"ahhh\", \"ohhh\"), d = NULL, e = 3, f = \"hii\")",
    "# Testing class",
    "expect_equal(\n  class(output_12655),\n  \"list\",\n  fixed = TRUE)",
    "# Testing type",
    "expect_type(\n  output_12655,\n  type = \"list\")",
    "# Testing values",
    "expect_equal(\n  output_12655,\n  list(n = 15, m = \"hii: ahhh, ohhh\"))",
    "# Testing names",
    "expect_equal(\n  names(output_12655),\n  c(\"n\", \"m\"),\n  fixed = TRUE)",
    "# Testing length",
    "expect_equal(\n  length(output_12655),\n  2L)",
    "# Testing sum of element lengths",
    "expect_equal(\n  sum(xpectr::element_lengths(output_12655)),\n  2L)",
    " ",
    "# Testing fn(a = 3, a_fn = mean, b = c(\"ahhh\", \"ohhh\"), ...",
    "# Changed from baseline: a",
    "xpectr::set_test_seed(42)",
    "# Testing side effects",
    "expect_error(\n  xpectr::strip_msg(fn(a = 3, a_fn = mean, b = c(\"ahhh\", \"ohhh\"), d = NULL, e = 3, f = \"hii\")),\n  xpectr::strip(\"1 assertions failed:\\n * Variable 'a': Element 1 is not >= 4.\"),\n  fixed = TRUE)",
    " ",
    "# Testing fn(a = 7, a_fn = mean, b = c(\"ahhh\", \"ohhh\"), ...",
    "# Changed from baseline: a",
    "xpectr::set_test_seed(42)",
    "# Testing side effects",
    "expect_error(\n  xpectr::strip_msg(fn(a = 7, a_fn = mean, b = c(\"ahhh\", \"ohhh\"), d = NULL, e = 3, f = \"hii\")),\n  xpectr::strip(\"1 assertions failed:\\n * Variable 'a': Element 1 is not <= 6.\"),\n  fixed = TRUE)",
    " ",
    "# Testing fn(a = NA, a_fn = mean, b = c(\"ahhh\", \"ohhh\"),...",
    "# Changed from baseline: a",
    "xpectr::set_test_seed(42)",
    "# Testing side effects",
    "expect_error(\n  xpectr::strip_msg(fn(a = NA, a_fn = mean, b = c(\"ahhh\", \"ohhh\"), d = NULL, e = 3, f = \"hii\")),\n  xpectr::strip(\"1 assertions failed:\\n * Variable 'a': May not be NA.\"),\n  fixed = TRUE)",
    " ",
    "# Testing fn(a = NULL, a_fn = mean, b = c(\"ahhh\", \"ohhh\"...",
    "# Changed from baseline: a",
    "xpectr::set_test_seed(42)",
    "# Testing side effects",
    "expect_error(\n  xpectr::strip_msg(fn(a = NULL, a_fn = mean, b = c(\"ahhh\", \"ohhh\"), d = NULL, e = 3, f = \"hii\")),\n  xpectr::strip(paste0(\"1 assertions failed:\\n * Variable 'a': Must be of type 'num\",\n                       \"ber', not 'NULL'.\")),\n  fixed = TRUE)",
    " ",
    "# Testing fn(a = 5, a_fn = sum, b = c(\"ahhh\", \"ohhh\"), d...",
    "# Changed from baseline: a_fn",
    "xpectr::set_test_seed(42)",
    "# Assigning output",
    "output_18983 <- fn(a = 5, a_fn = sum, b = c(\"ahhh\", \"ohhh\"), d = NULL, e = 3, f = \"hii\")",
    "# Testing class",
    "expect_equal(\n  class(output_18983),\n  \"list\",\n  fixed = TRUE)",
    "# Testing type",
    "expect_type(\n  output_18983,\n  type = \"list\")",
    "# Testing values",
    "expect_equal(\n  output_18983,\n  list(n = 15, m = \"hii: ahhh, ohhh\"))",
    "# Testing names",
    "expect_equal(\n  names(output_18983),\n  c(\"n\", \"m\"),\n  fixed = TRUE)",
    "# Testing length",
    "expect_equal(\n  length(output_18983),\n  2L)",
    "# Testing sum of element lengths",
    "expect_equal(\n  sum(xpectr::element_lengths(output_18983)),\n  2L)",
    " ",
    "# Testing fn(a = 5, a_fn = NULL, b = c(\"ahhh\", \"ohhh\"), ...",
    "# Changed from baseline: a_fn",
    "xpectr::set_test_seed(42)",
    "# Testing side effects",
    "expect_error(\n  xpectr::strip_msg(fn(a = 5, a_fn = NULL, b = c(\"ahhh\", \"ohhh\"), d = NULL, e = 3, f = \"hii\")),\n  xpectr::strip(paste0(\"1 assertions failed:\\n * Variable 'a_fn': Must be a functio\",\n                       \"n, not 'NULL'.\")),\n  fixed = TRUE)",
    " ",
    "# Testing fn(a = 5, a_fn = mean, b = c(\"ehhh\", \"loool\"),...",
    "# Changed from baseline: b",
    "xpectr::set_test_seed(42)",
    "# Assigning output",
    "output_16607 <- fn(a = 5, a_fn = mean, b = c(\"ehhh\", \"loool\"), d = NULL, e = 3, f = \"hii\")",
    "# Testing class",
    "expect_equal(\n  class(output_16607),\n  \"list\",\n  fixed = TRUE)",
    "# Testing type",
    "expect_type(\n  output_16607,\n  type = \"list\")",
    "# Testing values",
    "expect_equal(\n  output_16607,\n  list(n = 15, m = \"hii: ehhh, loool\"))",
    "# Testing names",
    "expect_equal(\n  names(output_16607),\n  c(\"n\", \"m\"),\n  fixed = TRUE)",
    "# Testing length",
    "expect_equal(\n  length(output_16607),\n  2L)",
    "# Testing sum of element lengths",
    "expect_equal(\n  sum(xpectr::element_lengths(output_16607)),\n  2L)",
    " ",
    "# Testing fn(a = 5, a_fn = mean, b = c(\"jj\", \"ll\"), d = ...",
    "# Changed from baseline: b",
    "xpectr::set_test_seed(42)",
    "# Testing side effects",
    "expect_error(\n  xpectr::strip_msg(fn(a = 5, a_fn = mean, b = c(\"jj\", \"ll\"), d = NULL, e = 3, f = \"hii\")),\n  xpectr::strip(paste0(\"1 assertions failed:\\n * Variable 'b': All elements must ha\",\n                       \"ve at least 3 characters.\")),\n  fixed = TRUE)",
    " ",
    "# Testing fn(a = 5, a_fn = mean, b = c(\"ehhh\", \"loool\", ...",
    "# Changed from baseline: b",
    "xpectr::set_test_seed(42)",
    "# Testing side effects",
    "expect_error(\n  xpectr::strip_msg(fn(a = 5, a_fn = mean, b = c(\"ehhh\", \"loool\", \"heeej\"), d = NULL, e = 3, f = \"hii\")),\n  xpectr::strip(paste0(\"1 assertions failed:\\n * Variable 'b': Must have length 2, \",\n                       \"but has length 3.\")),\n  fixed = TRUE)",
    " ",
    "# Testing fn(a = 5, a_fn = mean, b = NULL, d = NULL, e =...",
    "# Changed from baseline: b",
    "xpectr::set_test_seed(42)",
    "# Testing side effects",
    "expect_error(\n  xpectr::strip_msg(fn(a = 5, a_fn = mean, b = NULL, d = NULL, e = 3, f = \"hii\")),\n  xpectr::strip(paste0(\"1 assertions failed:\\n * Variable 'b': Must be of type 'cha\",\n                       \"racter', not 'NULL'.\")),\n  fixed = TRUE)",
    " ",
    "# Testing fn(a = 5, a_fn = mean, b = c(\"ahhh\", \"ohhh\"), ...",
    "# Changed from baseline: d",
    "xpectr::set_test_seed(42)",
    "# Testing side effects",
    "expect_error(\n  xpectr::strip_msg(fn(a = 5, a_fn = mean, b = c(\"ahhh\", \"ohhh\"), d = data.frame(col1 = c(1)), e = 3, f = \"hii\")),\n  xpectr::strip(paste0(\"1 assertions failed:\\n * Variable 'd': Must have at least 3\",\n                       \" rows, but has 1 rows.\")),\n  fixed = TRUE)",
    " ",
    "# Testing fn(a = 5, a_fn = mean, b = c(\"ahhh\", \"ohhh\"), ...",
    "# Changed from baseline: e",
    "xpectr::set_test_seed(42)",
    "# Testing side effects",
    "expect_error(\n  xpectr::strip_msg(fn(a = 5, a_fn = mean, b = c(\"ahhh\", \"ohhh\"), d = NULL, e = NA, f = \"hii\")),\n  xpectr::strip(\"1 assertions failed:\\n * Variable 'e': May not be NA.\"),\n  fixed = TRUE)",
    " ",
    "# Testing fn(a = 5, a_fn = mean, b = c(\"ahhh\", \"ohhh\"), ...",
    "# Changed from baseline: e",
    "xpectr::set_test_seed(42)",
    "# Assigning output",
    "output_13841 <- fn(a = 5, a_fn = mean, b = c(\"ahhh\", \"ohhh\"), d = NULL, e = 6, f = \"hii\")",
    "# Testing class",
    "expect_equal(\n  class(output_13841),\n  \"list\",\n  fixed = TRUE)",
    "# Testing type",
    "expect_type(\n  output_13841,\n  type = \"list\")",
    "# Testing values",
    "expect_equal(\n  output_13841,\n  list(n = 30, m = \"hii: ahhh, ohhh\"))",
    "# Testing names",
    "expect_equal(\n  names(output_13841),\n  c(\"n\", \"m\"),\n  fixed = TRUE)",
    "# Testing length",
    "expect_equal(\n  length(output_13841),\n  2L)",
    "# Testing sum of element lengths",
    "expect_equal(\n  sum(xpectr::element_lengths(output_13841)),\n  2L)",
    " ",
    "# Testing fn(a = 5, a_fn = mean, b = c(\"ahhh\", \"ohhh\"), ...",
    "# Changed from baseline: e",
    "xpectr::set_test_seed(42)",
    "# Assigning output",
    "output_17698 <- fn(a = 5, a_fn = mean, b = c(\"ahhh\", \"ohhh\"), d = NULL, e = NULL, f = \"hii\")",
    "# Testing class",
    "expect_equal(\n  class(output_17698),\n  \"list\",\n  fixed = TRUE)",
    "# Testing type",
    "expect_type(\n  output_17698,\n  type = \"list\")",
    "# Testing values",
    "expect_equal(\n  output_17698,\n  list(n = NaN, m = \"hii: ahhh, ohhh\"))",
    "# Testing names",
    "expect_equal(\n  names(output_17698),\n  c(\"n\", \"m\"),\n  fixed = TRUE)",
    "# Testing length",
    "expect_equal(\n  length(output_17698),\n  2L)",
    "# Testing sum of element lengths",
    "expect_equal(\n  sum(xpectr::element_lengths(output_17698)),\n  2L)",
    " ",
    "# Testing fn(a = 5, a_fn = mean, b = c(\"ahhh\", \"ohhh\"), ...",
    "# Changed from baseline: f",
    "xpectr::set_test_seed(42)",
    "# Assigning output",
    "output_14976 <- fn(a = 5, a_fn = mean, b = c(\"ahhh\", \"ohhh\"), d = NULL, e = 3, f = \"lol\")",
    "# Testing class",
    "expect_equal(\n  class(output_14976),\n  \"list\",\n  fixed = TRUE)",
    "# Testing type",
    "expect_type(\n  output_14976,\n  type = \"list\")",
    "# Testing values",
    "expect_equal(\n  output_14976,\n  list(n = 15, m = \"lol: ahhh, ohhh\"))",
    "# Testing names",
    "expect_equal(\n  names(output_14976),\n  c(\"n\", \"m\"),\n  fixed = TRUE)",
    "# Testing length",
    "expect_equal(\n  length(output_14976),\n  2L)",
    "# Testing sum of element lengths",
    "expect_equal(\n  sum(xpectr::element_lengths(output_14976)),\n  2L)",
    " ",
    "# Testing fn(a = 5, a_fn = mean, b = c(\"ahhh\", \"ohhh\"), ...",
    "# Changed from baseline: f",
    "xpectr::set_test_seed(42)",
    "# Testing side effects",
    "expect_error(\n  xpectr::strip_msg(fn(a = 5, a_fn = mean, b = c(\"ahhh\", \"ohhh\"), d = NULL, e = 3, f = NA)),\n  xpectr::strip(\"1 assertions failed:\\n * Variable 'f': May not be NA.\"),\n  fixed = TRUE)",
    " ",
    "# Testing fn(a = 5, a_fn = mean, b = c(\"ahhh\", \"ohhh\"), ...",
    "# Changed from baseline: f",
    "xpectr::set_test_seed(42)",
    "# Testing side effects",
    "expect_error(\n  xpectr::strip_msg(fn(a = 5, a_fn = mean, b = c(\"ahhh\", \"ohhh\"), d = NULL, e = 3, f = 3)),\n  xpectr::strip(paste0(\"1 assertions failed:\\n * Variable 'f': Must be of type 'str\",\n                       \"ing', not 'double'.\")),\n  fixed = TRUE)",
    " ",
    "# Testing fn(a = 5, a_fn = mean, b = c(\"ahhh\", \"ohhh\"), ...",
    "# Changed from baseline: f",
    "xpectr::set_test_seed(42)",
    "# Testing side effects",
    "expect_error(\n  xpectr::strip_msg(fn(a = 5, a_fn = mean, b = c(\"ahhh\", \"ohhh\"), d = NULL, e = 3, f = NULL)),\n  xpectr::strip(paste0(\"1 assertions failed:\\n * Variable 'f': Must be of type 'str\",\n                       \"ing', not 'NULL'.\")),\n  fixed = TRUE)",
    " ",
    "## Finished testing 'fn'                                                    ####",
    " "
  )

  set_test_seed(1)
  expect_equal(
    strip(gxs_function(fn, list(
      "a" = list(5, 3, 7, NA),
      a_fn = list(mean, sum),
      "b" = list(c("ahhh","ohhh"), c("ehhh","loool"), c("jj","ll"),  c("ehhh","loool", "heeej")),
      "d" = list(NULL, data.frame("col1" = c(1))),
      "e" = list(3, 6, NA),
      "f" = list("hii", "lol", NA, 3)
    ),
    out = "return")),
    strip(expected_tests2),
    fixed = TRUE)

  eval_expectations(expected_tests2, envir = current_envir)

  ## Second function

  fn2 <- function(x, y, z){
    if (x>3) stop("'x' > 3")
    if (y<0) warning("'y'<0")
    if (z==10) message("'z' was 10!")
    x + y + z
  }

  # assignment names are random
  set_test_seed(1)
  fn2_expected_tests <- c(
    " ",
    "## Testing 'fn2'                                                            ####",
    "## Initially generated by xpectr",
    "# Testing different combinations of argument values",
    "",
    "# Testing fn2(x = 2, y = 0, z = 5)",
    "xpectr::set_test_seed(42)",
    "# Assigning output",
    "output_12655 <- fn2(x = 2, y = 0, z = 5)",
    "# Testing class",
    "expect_equal(\n  class(output_12655),\n  \"numeric\",\n  fixed = TRUE)",
    "# Testing type",
    "expect_type(\n  output_12655,\n  type = \"double\")",
    "# Testing values",
    "expect_equal(\n  output_12655,\n  7,\n  tolerance = 1e-4)",
    "# Testing names",
    "expect_equal(\n  names(output_12655),\n  NULL,\n  fixed = TRUE)",
    "# Testing length",
    "expect_equal(\n  length(output_12655),\n  1L)",
    "# Testing sum of element lengths",
    "expect_equal(\n  sum(xpectr::element_lengths(output_12655)),\n  1L)",
    "",
    "# Testing fn2(x = 4, y = 0, z = 5)",
    "# Changed from baseline: x",
    "xpectr::set_test_seed(42)",
    "# Testing side effects",
    "expect_error(\n  xpectr::strip_msg(fn2(x = 4, y = 0, z = 5)),\n  xpectr::strip(\"'x' > 3\"),\n  fixed = TRUE)",
    "",
    "# Testing fn2(x = NA, y = 0, z = 5)",
    "# Changed from baseline: x",
    "xpectr::set_test_seed(42)",
    "# Testing side effects",
    "expect_error(\n  xpectr::strip_msg(fn2(x = NA, y = 0, z = 5)),\n  xpectr::strip(\"missing value where TRUE/FALSE needed\"),\n  fixed = TRUE)",
    "",
    "# Testing fn2(x = NULL, y = 0, z = 5)",
    "# Changed from baseline: x",
    "xpectr::set_test_seed(42)",
    "# Testing side effects",
    "expect_error(\n  xpectr::strip_msg(fn2(x = NULL, y = 0, z = 5)),\n  xpectr::strip(\"argument is of length zero\"),\n  fixed = TRUE)",
    "",
    "# Testing fn2(x = 2, y = -1, z = 5)",
    "# Changed from baseline: y",
    "xpectr::set_test_seed(42)",
    "# Testing side effects",
    "# Assigning side effects",
    "side_effects_12016 <- xpectr::capture_side_effects(fn2(x = 2, y = -1, z = 5), reset_seed = TRUE)",
    "expect_equal(\n  xpectr::strip(side_effects_12016[['warnings']]),\n  xpectr::strip(\"'y'<0\"),\n  fixed = TRUE)",
    "expect_equal(\n  xpectr::strip(side_effects_12016[['messages']]),\n  xpectr::strip(character(0)),\n  fixed = TRUE)",
    "# Assigning output",
    "output_12016 <- xpectr::suppress_mw(fn2(x = 2, y = -1, z = 5))",
    "# Testing class",
    "expect_equal(\n  class(output_12016),\n  \"numeric\",\n  fixed = TRUE)",
    "# Testing type",
    "expect_type(\n  output_12016,\n  type = \"double\")",
    "# Testing values",
    "expect_equal(\n  output_12016,\n  6,\n  tolerance = 1e-4)",
    "# Testing names",
    "expect_equal(\n  names(output_12016),\n  NULL,\n  fixed = TRUE)",
    "# Testing length",
    "expect_equal(\n  length(output_12016),\n  1L)",
    "# Testing sum of element lengths",
    "expect_equal(\n  sum(xpectr::element_lengths(output_12016)),\n  1L)",
    "",
    "# Testing fn2(x = 2, y = NULL, z = 5)",
    "# Changed from baseline: y",
    "xpectr::set_test_seed(42)",
    "# Testing side effects",
    "expect_error(\n  xpectr::strip_msg(fn2(x = 2, y = NULL, z = 5)),\n  xpectr::strip(\"argument is of length zero\"),\n  fixed = TRUE)",
    "",
    "# Testing fn2(x = 2, y = 0, z = 10)",
    "# Changed from baseline: z",
    "xpectr::set_test_seed(42)",
    "# Testing side effects",
    "# Assigning side effects",
    "side_effects_19446 <- xpectr::capture_side_effects(fn2(x = 2, y = 0, z = 10), reset_seed = TRUE)",
    "expect_equal(\n  xpectr::strip(side_effects_19446[['warnings']]),\n  xpectr::strip(character(0)),\n  fixed = TRUE)",
    "expect_equal(\n  xpectr::strip(side_effects_19446[['messages']]),\n  xpectr::strip(\"'z' was 10!\\n\"),\n  fixed = TRUE)",
    "# Assigning output",
    "output_19446 <- xpectr::suppress_mw(fn2(x = 2, y = 0, z = 10))",
    "# Testing class",
    "expect_equal(\n  class(output_19446),\n  \"numeric\",\n  fixed = TRUE)",
    "# Testing type",
    "expect_type(\n  output_19446,\n  type = \"double\")",
    "# Testing values",
    "expect_equal(\n  output_19446,\n  12,\n  tolerance = 1e-4)",
    "# Testing names",
    "expect_equal(\n  names(output_19446),\n  NULL,\n  fixed = TRUE)",
    "# Testing length",
    "expect_equal(\n  length(output_19446),\n  1L)",
    "# Testing sum of element lengths",
    "expect_equal(\n  sum(xpectr::element_lengths(output_19446)),\n  1L)",
    "",
    "# Testing fn2(x = 2, y = 0, z = 15)",
    "# Changed from baseline: z",
    "xpectr::set_test_seed(42)",
    "# Assigning output",
    "output_16607 <- fn2(x = 2, y = 0, z = 15)",
    "# Testing class",
    "expect_equal(\n  class(output_16607),\n  \"numeric\",\n  fixed = TRUE)",
    "# Testing type",
    "expect_type(\n  output_16607,\n  type = \"double\")",
    "# Testing values",
    "expect_equal(\n  output_16607,\n  17,\n  tolerance = 1e-4)",
    "# Testing names",
    "expect_equal(\n  names(output_16607),\n  NULL,\n  fixed = TRUE)",
    "# Testing length",
    "expect_equal(\n  length(output_16607),\n  1L)",
    "# Testing sum of element lengths",
    "expect_equal(\n  sum(xpectr::element_lengths(output_16607)),\n  1L)",
    "",
    "# Testing fn2(x = 2, y = 0, z = NULL)",
    "# Changed from baseline: z",
    "xpectr::set_test_seed(42)",
    "# Testing side effects",
    "expect_error(\n  xpectr::strip_msg(fn2(x = 2, y = 0, z = NULL)),\n  xpectr::strip(\"argument is of length zero\"),\n  fixed = TRUE)",
    "",
    "## Finished testing 'fn2'                                                   ####",
    " "
  )

  set_test_seed(1)
  # Create expectations
  # Note: define the list in the call
  expect_equal(strip(gxs_function(fn2,
               list("x" = list(2, 4, NA),
                    "y" = list(0, -1),
                    "z" = list(5, 10, 15)),
               out = "return")),
               strip(fn2_expected_tests),
               fixed = TRUE)

  eval_expectations(fn2_expected_tests, envir = current_envir)


})

test_that("gxs_function() works with multiline function definitions as arg value", {

  fn1 <- function(x, y, z){
    x(1) + y + z
  }

  # gxs_function(fn1, args_values = list(
  #   "x" = list(function(a){
  #     b <- a * a
  #     b
  #   }),
  #   "y" = list(1),
  #   "z" = list(3)
  # ), indentation = 2)



  ## Testing 'fn1'                                                            ####
  ## Initially generated by xpectr
  # Testing different combinations of argument values

  # Testing fn1(x = function(a) { b <- a * a b}, y = 1, z ...
  # Assigning output
  output_11255 <- fn1(x = function(a) {
    b <- a * a
    b
  }, y = 1, z = 3)
  # Testing class
  expect_equal(
    class(output_11255),
    "numeric",
    fixed = TRUE)
  # Testing type
  expect_type(
    output_11255,
    type = "double")
  # Testing values
  expect_equal(
    output_11255,
    5,
    tolerance = 1e-4)
  # Testing names
  expect_equal(
    names(output_11255),
    NULL,
    fixed = TRUE)
  # Testing length
  expect_equal(
    length(output_11255),
    1L)
  # Testing sum of element lengths
  expect_equal(
    sum(xpectr::element_lengths(output_11255)),
    1L)

  # Testing fn1(x = NULL, y = 1, z = 3)
  # Testing side effects
  expect_error(
    xpectr::strip_msg(fn1(x = NULL, y = 1, z = 3)),
    xpectr::strip("could not find function 'x'"),
    fixed = TRUE)

  # Testing fn1(x = function(a) { b <- a * a b}, y = NULL,...
  # Assigning output
  output_12671 <- fn1(x = function(a) {
    b <- a * a
    b
  }, y = NULL, z = 3)
  # Testing class
  expect_equal(
    class(output_12671),
    "numeric",
    fixed = TRUE)
  # Testing type
  expect_type(
    output_12671,
    type = "double")
  # Testing values
  expect_equal(
    output_12671,
    numeric(0),
    tolerance = 1e-4)
  # Testing names
  expect_equal(
    names(output_12671),
    NULL,
    fixed = TRUE)
  # Testing length
  expect_equal(
    length(output_12671),
    0L)
  # Testing sum of element lengths
  expect_equal(
    sum(xpectr::element_lengths(output_12671)),
    0L)

  # Testing fn1(x = function(a) { b <- a * a b}, y = 1, z ...
  # Assigning output
  output_13860 <- fn1(x = function(a) {
    b <- a * a
    b
  }, y = 1, z = NULL)
  # Testing class
  expect_equal(
    class(output_13860),
    "numeric",
    fixed = TRUE)
  # Testing type
  expect_type(
    output_13860,
    type = "double")
  # Testing values
  expect_equal(
    output_13860,
    numeric(0),
    tolerance = 1e-4)
  # Testing names
  expect_equal(
    names(output_13860),
    NULL,
    fixed = TRUE)
  # Testing length
  expect_equal(
    length(output_13860),
    0L)
  # Testing sum of element lengths
  expect_equal(
    sum(xpectr::element_lengths(output_13860)),
    0L)

  ## Finished testing 'fn1'                                                   ####

})

