% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/calc.npar.R, R/create.parameter.list.R,
%   R/read.lst.R
\name{read_NM_output}
\alias{read_NM_output}
\alias{calc.npar}
\alias{create.parameter.list}
\alias{read.lst}
\title{Read NONMEM output files into Xpose 4}
\usage{
calc.npar(object)

create.parameter.list(listfile)

read.lst(filename)
}
\arguments{
\item{object}{The return value of \code{read.lst(filename)}}

\item{listfile}{A NONMEM output file.}

\item{filename}{A NONMEM output file.}
}
\value{
lists of read values.
}
\description{
These are functions that read in a NONMEM output file (a '*.lst' file) and
then format the input.
}
\section{Functions}{
\itemize{
\item \code{calc.npar}: calculates the number and type of parameters included in a
NONMEM output file

\item \code{create.parameter.list}: Reads parameters, uncertainty and termination messages included in a
NONMEM output file

\item \code{read.lst}: parses information out of NONMEM output.
}}

\seealso{
Other data functions: 
\code{\link{add_transformed_columns}},
\code{\link{change_graphical_parameters}},
\code{\link{change_misc_parameters}},
\code{\link{compute.cwres}()},
\code{\link{data.checkout}()},
\code{\link{data_extract_or_assign}},
\code{\link{db.names}()},
\code{\link{export.graph.par}()},
\code{\link{export.variable.definitions}()},
\code{\link{import.graph.par}()},
\code{\link{import.variable.definitions}()},
\code{\link{make.sb.data}()},
\code{\link{nsim}()},
\code{\link{par_cov_summary}},
\code{\link{read.TTE.sim.data}()},
\code{\link{read.nm.tables}()},
\code{\link{read_nm_table}()},
\code{\link{simprazExample}()},
\code{\link{tabulate.parameters}()},
\code{\link{xlabel}()},
\code{\link{xpose.data}},
\code{\link{xpose.print}()},
\code{\link{xpose4-package}},
\code{\link{xsubset}()}
}
\author{
Niclas Jonsson, Andrew Hooker & Justin Wilkins
}
\concept{data functions}
