% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/absval.cwres.vs.pred.by.cov.R
\name{absval.cwres.vs.pred.by.cov}
\alias{absval.cwres.vs.pred.by.cov}
\title{Absolute value of the conditional weighted residuals vs. population
predictions, conditioned on covariates, for Xpose 4}
\usage{
absval.cwres.vs.pred.by.cov(
  object,
  covs = "Default",
  ylb = "|CWRES|",
  type = "p",
  smooth = TRUE,
  idsdir = "up",
  main = "Default",
  ...
)
}
\arguments{
\item{object}{An xpose.data object.}

\item{covs}{A vector of covariates to use in the plot. If "Default" the 
the covariates defined in \code{object@Prefs@Xvardef$Covariates} are used.}

\item{ylb}{A string giving the label for the y-axis. \code{NULL} if none.}

\item{type}{Type of plot. The default is points only ("p"), but lines ("l")
and both ("b") are also available.}

\item{smooth}{Logical value indicating whether an x-y smooth should be
superimposed. The default is TRUE.}

\item{idsdir}{Direction for displaying point labels. The default is "up",
since we are displaying absolute values.}

\item{main}{The title of the plot.  If \code{"Default"} then a default title
is plotted. Otherwise the value should be a string like \code{"my title"} or
\code{NULL} for no plot title.}

\item{\dots}{Other arguments passed to \code{link{xpose.plot.default}}.}
}
\value{
Returns a stack of xyplots of |CWRES| vs PRED, conditioned on
covariates.
}
\description{
This is a plot of absolute population conditional weighted residuals
(|CWRES|) vs population predictions (PRED) conditioned by covariates, a
specific function in Xpose 4. It is a wrapper encapsulating arguments to the
\code{xpose.plot.default} function. Most of the options take their default
values from xpose.data object but may be overridden by supplying them as
arguments.
}
\details{
Each of the covariates in the Xpose data object, as specified in
\code{object@Prefs@Xvardef$Covariates}, is evaluated in turn, creating a
stack of plots.

The \code{main} argument is not supported owing to the multiple plots
generated by the function.

Conditional weighted residuals (CWRES) require some extra steps to
calculate. See \code{\link{compute.cwres}} for details.

A wide array of extra options controlling xyplots are available. See
\code{\link{xpose.plot.default}} for details.
}
\examples{

absval.cwres.vs.pred.by.cov(simpraz.xpdb, covs=c("HCTZ","WT"), max.plots.per.page=2)

}
\seealso{
\code{\link{absval.cwres.vs.pred}},
\code{\link{xpose.plot.default}}, \code{\link{xpose.panel.default}},
\code{\link[lattice]{xyplot}}, \code{\link{xpose.prefs-class}},
\code{\link{compute.cwres}}, \code{\link{xpose.data-class}}

Other specific functions: 
\code{\link{absval.cwres.vs.cov.bw}()},
\code{\link{absval.cwres.vs.pred}()},
\code{\link{absval.iwres.cwres.vs.ipred.pred}()},
\code{\link{absval.iwres.vs.cov.bw}()},
\code{\link{absval.iwres.vs.idv}()},
\code{\link{absval.iwres.vs.ipred}()},
\code{\link{absval.iwres.vs.ipred.by.cov}()},
\code{\link{absval.iwres.vs.pred}()},
\code{\link{absval.wres.vs.cov.bw}()},
\code{\link{absval.wres.vs.idv}()},
\code{\link{absval.wres.vs.pred}()},
\code{\link{absval.wres.vs.pred.by.cov}()},
\code{\link{absval_delta_vs_cov_model_comp}},
\code{\link{addit.gof}()},
\code{\link{autocorr.cwres}()},
\code{\link{autocorr.iwres}()},
\code{\link{autocorr.wres}()},
\code{\link{basic.gof}()},
\code{\link{basic.model.comp}()},
\code{\link{cat.dv.vs.idv.sb}()},
\code{\link{cat.pc}()},
\code{\link{cov.splom}()},
\code{\link{cwres.dist.hist}()},
\code{\link{cwres.dist.qq}()},
\code{\link{cwres.vs.cov}()},
\code{\link{cwres.vs.idv}()},
\code{\link{cwres.vs.idv.bw}()},
\code{\link{cwres.vs.pred}()},
\code{\link{cwres.vs.pred.bw}()},
\code{\link{cwres.wres.vs.idv}()},
\code{\link{cwres.wres.vs.pred}()},
\code{\link{dOFV.vs.cov}()},
\code{\link{dOFV.vs.id}()},
\code{\link{dOFV1.vs.dOFV2}()},
\code{\link{data.checkout}()},
\code{\link{dv.preds.vs.idv}()},
\code{\link{dv.vs.idv}()},
\code{\link{dv.vs.ipred}()},
\code{\link{dv.vs.ipred.by.cov}()},
\code{\link{dv.vs.ipred.by.idv}()},
\code{\link{dv.vs.pred}()},
\code{\link{dv.vs.pred.by.cov}()},
\code{\link{dv.vs.pred.by.idv}()},
\code{\link{dv.vs.pred.ipred}()},
\code{\link{gof}()},
\code{\link{ind.plots}()},
\code{\link{ind.plots.cwres.hist}()},
\code{\link{ind.plots.cwres.qq}()},
\code{\link{ipred.vs.idv}()},
\code{\link{iwres.dist.hist}()},
\code{\link{iwres.dist.qq}()},
\code{\link{iwres.vs.idv}()},
\code{\link{kaplan.plot}()},
\code{\link{par_cov_hist}},
\code{\link{par_cov_qq}},
\code{\link{parm.vs.cov}()},
\code{\link{parm.vs.parm}()},
\code{\link{pred.vs.idv}()},
\code{\link{ranpar.vs.cov}()},
\code{\link{runsum}()},
\code{\link{wres.dist.hist}()},
\code{\link{wres.dist.qq}()},
\code{\link{wres.vs.idv}()},
\code{\link{wres.vs.idv.bw}()},
\code{\link{wres.vs.pred}()},
\code{\link{wres.vs.pred.bw}()},
\code{\link{xpose.VPC}()},
\code{\link{xpose.VPC.both}()},
\code{\link{xpose.VPC.categorical}()},
\code{\link{xpose4-package}}
}
\author{
E. Niclas Jonsson, Mats Karlsson, Andrew Hooker & Justin Wilkins
}
\concept{specific functions}
\keyword{methods}
